/* MushNetworkSocket.hh */
/* Created by Enomoto Sanshiro on 21 January 1998. */
/* Last updated by Enomoto Sanshiro on 19 November 1999. */


#ifndef __MushNetworkSocket_hh__
#define __MushNetworkSocket_hh__

#include <string>
#include "MushDefs.hh"
#include "MushSocket.hh"


class TMushNetworkSocket: virtual public TMushSocket {
  public:
    TMushNetworkSocket(int PortNumber);
    virtual ~TMushNetworkSocket();
    static unsigned long HostAddressByName(std::string HostName) throw(TSystemCallException);
    static std::string LocalIPAddress(void);
    static std::string LocalHostName(void);
    unsigned long LocalAddress(void) const;
    std::string RemoteIPAddress(void) const;
    std::string RemoteHostName(void) const;
    unsigned long RemoteAddress(void) const;
  protected:
    int _PortNumber;
    static unsigned long _LocalAddress;
    static std::string _LocalHostName;
    static std::string _LocalIPAddress;
    unsigned _RemoteAddress;
    std::string _RemoteHostName;
    std::string _RemoteIPAddress;
    static void SetupLocalHostName(void) throw(TSystemCallException);
    void SetupRemoteHostName(unsigned long RemoteAddress) throw(TSystemCallException);
};


class TMushServerNetworkSocket: public TMushServerSocket, public TMushNetworkSocket {
  public:
    TMushServerNetworkSocket(int PortNumber) throw(TSystemCallException);
    virtual void Bind(void) throw(TSystemCallException);
    virtual void Accept(void) throw(TSystemCallException);
};


class TMushClientNetworkSocket: public TMushClientSocket, public TMushNetworkSocket {
  public:
    TMushClientNetworkSocket(std::string RemoteHostName, int PortNumber) throw(TSystemCallException);
    virtual void Connect(void) throw(TSystemCallException);
};


#endif
