// FTP žץ

#include <errno.h>
#include <stdio.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <sys/uio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <setjmp.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>

// ɬפʤ餯廊Ƥ
// #include <sysent.h>
#ifdef __SUNPRO_CC
#include <sysent.h>
#endif

#include "ftp.h"

// gethostname к
#ifdef NEED_GETHOSTNAME
extern int gethostname(char *name, int len);
#endif

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long  dword;

byte ReceivePort[6];

const int ReceivePS=4096;
const int ReceivePE=8192;

inline int Isnumber(char c)
{
    if(c<'0') return 0;
    if(c>'9') return 0;
    return 1;
}

int OpenReceivePort(void)
{
    char localhost[200];
    if(gethostname(localhost,200)<0)
      {
	  fprintf(Err,"cannot get local host name\n");
	  return -1;
      }

    struct hostent *hp;
    if((hp=gethostbyname(localhost))==NULL)
      {
	  fprintf(Err,"cannot get localhost info.\n");
	  return -1;
      }
    
    // ݡȤΥץ
    struct sockaddr_in sin;

    int sd;
    int on=1;
    static int ftprport=-1;
    int i;

    
    memset((char *)&sin,0,sizeof(sin));
    sin.sin_port=htons(ftprport);
    sin.sin_family=PF_INET;
    memcpy(&sin.sin_addr,hp->h_addr,hp->h_length);
    
    /* host  IP Ÿ */
    ReceivePort[0]=((byte *)hp->h_addr)[0];
    ReceivePort[1]=((byte *)hp->h_addr)[1];
    ReceivePort[2]=((byte *)hp->h_addr)[2];
    ReceivePort[3]=((byte *)hp->h_addr)[3];
    if(ReportLevel>10)
      printf("%d.%d.%d.%d\n",ReceivePort[0],ReceivePort[1],ReceivePort[2],ReceivePort[3]);

    if((sd=socket(PF_INET,SOCK_STREAM,0))<0)
      {
	  fprintf(Err,"cannot create socket\n");
	  return -1;
      }

    setsockopt(sd,SOL_SOCKET,SO_REUSEADDR,(char *)&on,sizeof(int));
    
/*    int sbuffsize=8192;
    if(setsockopt(sd,SOL_SOCKET,SO_SNDBUF,(char *)&sbuffsize,
		  sizeof(sbuffsize))==-1)
      perror("s");
    if(setsockopt(sd,SOL_SOCKET,SO_RCVBUF,(char *)&sbuffsize,
		  sizeof(sbuffsize))==-1)
      perror("s");*/


    if(ftprport==-1)
      ftprport=ReceivePS+time(NULL)%(ReceivePE-ReceivePS);
    i=ftprport;
    while(1)
      {
	  i++;
	  if(i>ReceivePE)
	    i=ReceivePS;
	  if(i==ftprport)
	    {
		fprintf(Err,"cannot get port\n");
		return -1;
	    }
	  
	  sin.sin_port=htons(i);
	  if(bind(sd,(struct sockaddr *)&sin,sizeof(sin))<0)
	    {
		if (errno == EADDRINUSE)
		  {
/*		      putchar('.');
		      fflush(stdout);*/
		      continue;
		  }
		fprintf(Err,"cannot bind socket\n");
		return -1;
	    }
	  ftprport=i;
	  break;
      }

    ReceivePort[4]=i/256;
    ReceivePort[5]=i%256;

    if(ReportLevel>10)
      printf("portid: %d,%d\n",(i)/256,(i)%256);
    listen(sd,1);
	  
    return sd;
}  


int OpenFTPConnection(char *addr,int port)
{
    struct sockaddr_in sin;
    struct servent *sp;
    struct hostent *hp;
    int sd;
    long i_addr;

    // ɥ쥹åå
    
    if(Isnumber(addr[0]))         // IP ɥ쥹
      {
	  i_addr=inet_addr(addr);
/*	  if((hp=gethostbyaddr((char *)&i_addr,sizeof(i_addr),AF_INET))==NULL)
	    {
		fprintf(Err,"error: cannot get host info \n");
		return -1;
	    }*/
	  memset((char *)&sin,0,sizeof(sin));
//	  memcpy(&sin.sin_addr,hp->h_addr,hp->h_length);
	  memcpy(&sin.sin_addr,&i_addr,4);
      }
    else
      { 
	  if((hp=gethostbyname(addr))==NULL)
	    {
		fprintf(Err,
			"OpenFTPConnection: cannot get local host info \n");
		return -1;
	    }
	  memset((char *)&sin,0,sizeof(sin));
	  memcpy(&sin.sin_addr,hp->h_addr,hp->h_length);
      }
    
    sin.sin_family=PF_INET;
    sin.sin_port=htons(port);
    
    if((sd=socket(PF_INET,SOCK_STREAM,0))<0)
      {
	  fprintf(Err,"OpenConnection: cannot create socket\n");   
	  return -1;
      }
    if(connect(sd,(struct sockaddr *)&sin,sizeof(sin))<0)
      {
	  fprintf(Err,"OpenConnection: cannot connect to server %s\n",addr);
	  close(sd);
	  return -1;
      }
    return sd;
}


static jmp_buf env;

// žΥॢȽ
static void timeout(int sig)
{
    signal(sig,SIG_IGN);
    signal(SIGALRM,timeout);
    longjmp(env,1);
}

// ³ڤޤɤߤȤ
char *ReceiveUntilLast(int lsd,int &len)
{
    // ³

    int sd;
#if defined(_AIX)        // thanks to Mr.Okuyama
	size_t	nbyte;
#else
	int	nbyte;
#endif
    struct sockaddr from;
    int zerocount=10;

    while(1)
      {
	  if((sd=accept(lsd, &from, &nbyte))<0)
	    {
		if(errno != 14)
		  {
		      fprintf(Err,"ReceiveUntilLast:AcceptError\n");
		      return NULL;
		  }
		continue;
	    }
	  break;
      }
    close(lsd);

    // μ
    int max=1024*16;
    char *tmp;
    tmp=(char *)malloc(max);
    if(tmp==NULL)
      {
	  fprintf(Err,"FTP:ReceiveUntilLast: cannot alloc memory(%d)\n"
		  ,max);
	  close(sd);   // 
	  return NULL;
    
      }

    // ॢ
    signal(SIGALRM,timeout);

    if(setjmp(env)!=0)
      {             // Ƥ
	  fprintf(Err,"FTP: Transfer timed out by 5 minutes.\n");
	  TransferError=TETimeOut;
	  close(sd);
	  free(tmp);
	  signal(SIGALRM,SIG_IGN);
	  return NULL;
      }
    
    alarm(300); // ʬ  

    // ɤɤ
    int sz=0,r;
    char *p;
    while(1)
      {
/*	  if(Termination)
	    {
		TransferError=TEMisc;
		close(sd);
		free(tmp);
		signal(SIGALRM,SIG_IGN);
		return NULL;
	    }*/

	  r=read(sd,tmp+sz,1024);
	  if(r<1) 
	    {
		zerocount--;
		if(zerocount==0)
		  break;
		continue;
	    }
	  else
	    zerocount=10;	    

	  alarm(300);
	  if(ReportLevel>=2)
	    {
		if(r>512)
		  putchar('O');
		else if(r>100)
		  putchar('o');
		else
		  putchar('.');
		fflush(stdout);
	    }
	  sz+=r;
		
	  // 
	  if(max-sz<2048)
	    {
		max+=16*1024;
		p=(char *)realloc(tmp,max);
		if(p==NULL)
		  {
		      fprintf(Err,"OpenURL: realloc failed\n");
		      close(sd);
		      free(tmp);
		      signal(SIGALRM,SIG_IGN);
		      alarm(0);
		      return NULL;
		  }
		tmp=p;
	    }	  
      }
    close(sd);

    len=sz;
    return tmp;
}

// FTP Υåȶǻǽ
int PipeTermination=0;
static void pipehandler(int sig)
{
    PipeTermination=1;
    signal(SIGPIPE,SIG_IGN);
}

int FTPAnswer(FILE *fp,char *s)
{
    char tmp[400];
    int code;
    if(PipeTermination)
      {
	  sprintf(s,"Connection terminated by server\n");
	  return 999;         // 顼
      }
    while(1)
      {
	  if(fgets(tmp,400,fp)==NULL)
	    return -1;
	  if(ReportLevel>10)
	    printf(">> %s",tmp);
	  if(tmp[3]!=' ')
	    continue;                // ̵
	  if(sscanf(tmp,"%d %s",&code,s)==0)
	    continue;
	  break;
      }
    strcpy(s,tmp+4);
    return code;
}
    

char *FTPDirectory(char *host,int port,char *user,char *pass,char *dir,
		   int &size,char *actualserver)
{
    
    int ftp21;
    ftp21=OpenFTPConnection(host,port);
    if(ftp21<0)
      {
	  TransferError=TENoServer;
	  return NULL;
      }
    size=0;
    FILE *fpr,*fpw;
    fpr=fdopen(ftp21,"r");
    fpw=fdopen(ftp21,"w");

    if((fpr==NULL)||(fpw==NULL))
      {
	  if(fpr) fclose(fpr);
	  if(fpw) fclose(fpw);
	  close(ftp21);
	  TransferError=TENoServer;
	  return NULL;
      }

    char buff[300];

    if(FTPAnswer(fpr,buff)>220)
      {
	  fprintf(Err,"cannot access for '%s'",buff); 
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  TransferError=TENoServer;
	  return NULL;
      }

    sprintf(buff,"USER %s\r\n",user);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)>399)
      {
	  fprintf(Err,"cannot login for '%s'",buff); 
	  TransferError=TENoAuthorization;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }
    sprintf(buff,"PASS %s\r\n",pass);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)>399)
      {
	  fprintf(Err,"cannot login for '%s'",buff); 
	  TransferError=TENoAuthorization;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }

    // Delegate ͳ³
    if(actualserver)
      {
	  sprintf(buff,"CWD //%s\r\n",actualserver);
	  fprintf(fpw,buff);
	  fflush(fpw);
	  if(ReportLevel>10)
	    printf("%s\n",buff);
	  if(FTPAnswer(fpr,buff)>399)
	    {
		fprintf(Err,"cannot connect for '%s' via %s",
			actualserver,host); 
		TransferError=TENoServer;
		fclose(fpw);
		fclose(fpr);
		close(ftp21);
		return NULL;
	    }
      }

    
    // ǥ쥯ȥμ
    int rsd=OpenReceivePort();
    if(rsd<0)
      {
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }

    sprintf(buff,"PORT %d,%d,%d,%d,%d,%d\r\n",
	    ReceivePort[0],ReceivePort[1],ReceivePort[2],
	    ReceivePort[3],ReceivePort[4],ReceivePort[5]);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)!=200)
      {
	  fprintf(Err,"cannot teach port %s",buff); 
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }


    sprintf(buff,"LIST %s\r\n",dir);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)!=150)
      {
	  fprintf(Err,"cannot get list for '%s'",buff); 
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }
    // 
    char *p;
    int len;
    p=ReceiveUntilLast(rsd,len);


    if((p==NULL)||(FTPAnswer(fpr,buff)!=226))
      {
	  if(TransferError==TENoError)
	    fprintf(Err,"cannot transfer completely  %s",buff); 
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  if(p)
	    free(p);
	  return NULL;
      }
    if(ReportLevel>=1)
      printf("ftp transfer :%dbytes\n",len);
    size=len;
    fprintf(fpw,"QUIT\r\n");
    fflush(fpw);
    fclose(fpw);
    fclose(fpr);
    close(ftp21);
    TransferError=TENoError;
    return p;
}

// եμ 

char *FTPFileGet(char *host,int port,char *user,char *pass,
		 char *file,int &size,char *actualserver)
{
    int ftp21;
    ftp21=OpenFTPConnection(host,port);
    if(ftp21<0)
      {
	  TransferError=TENoServer;
	  return NULL;
      }

    size=0;

    FILE *fpr,*fpw;
    fpr=fdopen(ftp21,"r");
    fpw=fdopen(ftp21,"w");

    if((fpr==NULL)||(fpw==NULL))
      {
	  if(fpr) fclose(fpr);
	  if(fpw) fclose(fpw);
	  close(ftp21);
	  TransferError=TENoServer;
	  return NULL;
      }

    char buff[300];

    if(FTPAnswer(fpr,buff)>220)
      {
	  fprintf(Err,"cannot access for '%s'",buff); 
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  TransferError=TENoServer;
	  return NULL;
      }

    sprintf(buff,"USER %s\r\n",user);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)>399)
      {
	  fprintf(Err,"cannot login for '%s'",buff); 
	  TransferError=TENoAuthorization;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }
    sprintf(buff,"PASS %s\r\n",pass);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)>399)
      {
	  fprintf(Err,"cannot login for '%s'",buff); 
	  TransferError=TENoAuthorization;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }

    // Delegate ͳ³
    if(actualserver)
      {
	  sprintf(buff,"CWD //%s\r\n",actualserver);
	  fprintf(fpw,buff);
	  fflush(fpw);
	  if(ReportLevel>10)
	    printf("%s\n",buff);
	  if(FTPAnswer(fpr,buff)>399)
	    {
		fprintf(Err,"cannot connect for '%s' via %s",
			actualserver,host); 
		TransferError=TENoServer;
		fclose(fpw);
		fclose(fpr);
		close(ftp21);
		return NULL;
	    }
      }

    sprintf(buff,"TYPE I\r\n",pass);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)>399)
      {
	  fprintf(Err,"cannot change mode for '%s'",buff); 
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }
    
    // ǥ쥯ȥμ
    int rsd=OpenReceivePort();
    if(rsd<0)
      {
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }

    sprintf(buff,"PORT %d,%d,%d,%d,%d,%d\r\n",
	    ReceivePort[0],ReceivePort[1],ReceivePort[2],
	    ReceivePort[3],ReceivePort[4],ReceivePort[5]);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)!=200)
      {
	  fprintf(Err,"cannot teach port %s",buff); 
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }


    sprintf(buff,"RETR %s\r\n",file);
    fprintf(fpw,buff);
    fflush(fpw);
    if(ReportLevel>10)
      printf("%s\n",buff);
    if(FTPAnswer(fpr,buff)!=150)
      {
	  fprintf(Err,"cannot get file for '%s'",buff); 
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  return NULL;
      }
    // 
    char *p;
    int len;
    p=ReceiveUntilLast(rsd,len);


    if((p==NULL)||(FTPAnswer(fpr,buff)!=226))
      {
	  if(TransferError==TENoError)
	    fprintf(Err,"cannot transfer completely  '%s'",buff); 
	  TransferError=TENoFile;
	  fclose(fpw);
	  fclose(fpr);
	  close(ftp21);
	  if(p)
	    free(p);
	  return NULL;
      }

    if(ReportLevel>=1)
      printf("ftp transfer: %d\n",len);
    size=len;
    fprintf(fpw,"QUIT\r\n");
    fflush(fpw);
    fclose(fpw);
    fclose(fpr);
    close(ftp21);
    TransferError=TENoError;
    return p;
}

char *GetFTP(char *server,int port, char *id,char *password,
	     char *file,int &size,char *actualserver)
{
    PipeTermination=0;
    signal(SIGPIPE,pipehandler);

    // Ǹʸ '/'  dir  file Ƚ
    if(file[strlen(file)-1]=='/')
      return FTPDirectory(server,port,id,password,file,size,actualserver);
    else
      return FTPFileGet(server,port,id,password,file,size,actualserver);
}



