#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <sys/uio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <setjmp.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include "http.h"
#include "url.h"

FILE *Downlog;

char *UserAgent="Unknown";
char *Authorization=NULL;

inline int Isnumber(char c)
{
    if(c<'0') return 0;
    if(c>'9') return 0;
    return 1;
}

int OpenConnection(char *addr,int port)
{
    struct sockaddr_in sin;
    struct servent *sp;
    struct hostent *hp;
    int sd;
    long i_addr;

    // ɥ쥹åå
    
    if(Isnumber(addr[0]))         // IP ɥ쥹
      {
	  i_addr=inet_addr(addr);
/*	  if((hp=gethostbyaddr((char *)&i_addr,sizeof(i_addr),AF_INET))==NULL)
	    {
		fprintf(Err,"error: cannot get host info \n");
		return -1;
	    }*/
	  memset((char *)&sin,0,sizeof(sin));
//	  memcpy(&sin.sin_addr,hp->h_addr,hp->h_length);
	  memcpy(&sin.sin_addr,&i_addr,4);
      }
    else
      { 
	  if((hp=gethostbyname(addr))==NULL)
	    {
		fprintf(Err,
			"OpenConnection: cannot get local host info \n");
		fflush(Err);
		return -1;
	    }
	  memset((char *)&sin,0,sizeof(sin));
	  memcpy(&sin.sin_addr,hp->h_addr,hp->h_length);
      }
    
    sin.sin_family=PF_INET;
    sin.sin_port=htons(port);
    
    if((sd=socket(PF_INET,SOCK_STREAM,0))<0)
      {
	  fprintf(Err,"OpenConnection: cannot create socket\n");   
	  fflush(Err);
	  return -1;
      }
    if(connect(sd,(struct sockaddr *)&sin,sizeof(sin))<0)
      {
	  fprintf(Err,"OpenConnection: cannot connect to server %s:%d\n"
		  ,addr,port);
	  fflush(Err);
	  close(sd);
	  return -1;
      }
    return sd;
}


inline void Send(int sd,char *s)
{
    write(sd,s,strlen(s));
}

char *cwd;

void sgets(char *buff,int l,int sd)
{
    char t;
    int i=0;
    while(1)
      {
	  while(read(sd,&t,1)==0);
	  buff[i]=t;
	  if(i==l) return;
	  if(t=='\n') break;
	  i++;
      }
    buff[i]='\0';
}

static jmp_buf env;


// Content-Length  head Ĺ­֤
int SearchContentLength(char *buff,int size)
{
    buff[size]='\0';
    char *cl="Content-length:";

    // content length Υ
    char c;
    char *p;
    if(size==0) return 0;
    p=strstr(buff,cl);
    char *b=BodyOf(buff);
    if(p==NULL)
      return 0;
    
    p+=strlen(cl);
    
    int ll;
    if(sscanf(p,"%d",&ll)==0)
      return 0;
    if(ll==0)
      return 0;

    // Body Ƭ򤵤
    if(b==NULL) return 0;
    c= *b;
    *b='\0';
    int hh=strlen(buff);
    *b=c;

//    printf("(Content-Length: %d at %d) ",ll,hh);
    return ll+hh;
}
    
    

// žΥॢȽ
static void timeout(int sig)
{
    signal(sig,SIG_IGN);
    signal(SIGALRM,timeout);
    longjmp(env,1);
}


// Authoriazation ΤΡBase64 Encoding  =============
static char *MIMEs=
//0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef
 "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

char *Base64Encode(char *str)
{
    char *r;
    r=(char *)malloc(strlen(str)*2);
    
    int i,j,l=strlen(str);
    int s0,s1,s2;
    i=j=0;
    while(i<l)
      {
	  // ϤѰ;
	  s0=str[i];
	  if(i+1<l)
	    s1=str[i+1];
	  else
	    s1=0;
	  if(i+2<l)
	    s2=str[i+2];
	  else
	    s2=0;
	  
	  // ;
	  r[j+0]=MIMEs[((s0>>2)&0x3f)];                  // 000000**
	  r[j+1]=MIMEs[((s0<<4)&0x30)|((s1>>4)&0x0f)];   // ******00 1111****
	  r[j+2]=MIMEs[((s1<<2)&0x3c)|((s2>>6)&0x03)];   // ****1111 22******
	  r[j+3]=MIMEs[(s2&0x3f)];                       // **222222

	  i+=3;
	  j+=4;
      }
    r[j]='\0';
    return r;
}

void SetHTTPAuthorization(char *src)
{
    if(Authorization!=NULL)
      free(Authorization);
    Authorization=Base64Encode(src);
}

//  URL ž96/10/4 proxy б
char *GetHTTPRaw(char *server,int port,char *file,char *method,int &size)
{
    char *tmp,*p,*q;
    int sd,i;
    int max=1024*16;

    size=0;

    // ³
    tmp=(char *)malloc(max);
    if(tmp==NULL)
      {
	  fprintf(Err,"GetHTTPRaw: cannot alloc memory(%d)\n",max);
	  TransferError=TEMisc;
	  fflush(Err);
	  return NULL;
      }

    sd=OpenConnection(server,port);
	
    if(sd<0)
      {
	  fprintf(Err,"GetHTTPRaw: cannot connect to server\n");
	  fflush(Err);
	  TransferError=TENoServer;
	  free(tmp);
	  return NULL;
      }

    // ॢ
    signal(SIGALRM,timeout);

    if(setjmp(env)!=0)
      {             // Ƥ
	  fprintf(Err,"GetHTTPRaw: Transfer timed out by 5 minutes.\n");
	  fflush(Err);
	  TransferError=TETimeOut;
	  close(sd);
	  free(tmp);
	  signal(SIGALRM,SIG_IGN);
	  return NULL;
      }
    
    alarm(300); // ʬ  

    // ׵
    sprintf(tmp,"%s %s HTTP/1.0\r\n",method,file);
    Send(sd,tmp);
    sprintf(tmp,"User-Agent: %s using http.cc \r\n",UserAgent);
    Send(sd,tmp);
    // 줬򤹤뤳Ȥ뤫ϤƤ
//    Send(sd,"Connection: Keep-Alive\r\n");
    {  // send "Host:" 
	char *realhost=NULL;
	int realport=80;
	if(strncmp(file,"http:",5)==0)  // proxy 餷
	  {
	      realhost=URLServer(file,realport);
	  }
	else
	  {
	      realport=port;
	      realhost=strdup(server);
	  }
	// send
	if(realhost!=NULL)
	  {
	      if(realport==80)
		sprintf(tmp,"Host: %s\r\n",realhost);
	      else
		sprintf(tmp,"Host: %s:%d\r\n",realhost,realport);
	      Send(sd,tmp);
	      free(realhost);
	  }
    }
	      

    if(port==80)
    Send(sd,"Accept: */*\r\n");    /**/
    if(Authorization)
      {
	  sprintf(tmp,"Authorization: Basic %s\r\n",Authorization);
	  Send(sd,tmp);
      }
    Send(sd,"\r\n");

    // ɤɤ
    int sz=0,r;
    int conlen=0;
    while(1)
      {
	  r=read(sd,tmp+sz,1024);
	  if(r<1) break;
	  alarm(300);
	  if(ReportLevel>=2)
	    {
		if(r>512)
		  putchar('O');
		else if(r>100)
		  putchar('o');
		else
		  putchar('.');
	    }
	  fflush(stdout);
	  sz+=r;
	  if(conlen==0)    // ޤ content length 򤷤ʤ
	    {
		conlen=SearchContentLength(tmp,sz);
	    }
	  else             // content length äƤ
	    {
		if(sz>=conlen)
		  {
		      if(ReportLevel>=2)
			printf("<content cut %d>",sz);
		      break;
		  }
	    }
		
	  // 
	  if(max-sz<2048)
	    {
		max+=16*1024;
		p=(char *)realloc(tmp,max);
		if(p==NULL)
		  {
		      fprintf(Err,"GetHTTPRaw: realloc failed\n");
		      TransferError=TEMisc;
		      close(sd);
		      free(tmp);
		      signal(SIGALRM,SIG_IGN);
		      alarm(0);
		      return NULL;
		  }
		tmp=p;
	    }	  
      }
    close(sd);
    tmp[sz]='\0';
    // 쥹ݥȽ
    char tmp1[100],err[256];
    int code;
    if(sscanf(tmp,"%s %d %255s",tmp1,&code,err)==3)
      {
	  if((code<200)||(code>=400))
	    {
		char *t,*u;
		t=strchr(tmp,' ')+1;
		t=strchr(t,' ')+1;
		u=strchr(t,'\n');
		if(u) 
		  *u='\0';
		u=strchr(t,'\r');
		if(u) 
		  *u='\0';
		if(ReportLevel>=1)
		  printf(" %s ",t);
		free(tmp);
		TransferError=code;
		signal(SIGALRM,SIG_IGN);
		alarm(0);
		return NULL;
	    }
      }
    

    // ֤ΰ
    if(ReportLevel>=1)
      {
	  printf("http transfer %dbytes\n",sz);
      }
    q=(char *)realloc(tmp,sz+1);
    size=sz;
    if(q==NULL)
      {
	  fprintf(Err,"GetHTTPRaw: cannot realloc for return\n");
	  TransferError=TEMisc;
	  free(tmp);
      }
    q[sz]='\0';     // Τλߤ
    signal(SIGALRM,SIG_IGN);
    alarm(0);
    return q;
}

//  server/file ž
char *GetHTTP(char *server,int port,char *file,int &size)
{
    char *r;
    int sz;
    r=GetHTTPRaw(server,port,file,"GET",sz);
    if(r==NULL)
      return NULL;

    size=sz;
    char *p=BodyOf(r,size);
    if(p==NULL)
      return r;
    
    char *s=(char *)malloc(size+1);
    if(s==NULL)
      {
	  size=sz;
	  return r;
      }
    
    memcpy(s,p,size+1);
    free(r);
    return s;
}
      
    

// Τؤݥ
char *BodyOf(char *buff,int &size)
{
    char *p,*r;
    int f=0;
    if(buff==NULL) return NULL;

    p=buff;
    while(*p)
      {
	  if(*p==0x0a) break;
	  if(*p==0x0d) f=1;
	  p++;
      }
    if(f)     // \r\n ȤĤƤ
      {
	  r=strstr(buff,"\r\n\r\n");
	  if(r==NULL) return NULL;
	  r+=4;
      }
    else
      {
	  r=strstr(buff,"\n\n");
	  if(r==NULL) return NULL;
	  r+=2;
      }    
    
    char c;
    c=*r;
    *r='\0';
    size-=strlen(buff);
    *r=c;
    return r;
}



//  եեޥå
//  Sun, 06 Nov 1994 08:49:37 GMT    ; RFC 822RFC 1123ˤ깹줿
//  Sunday, 06-Nov-94 08:49:37 GMT   ; RFC 850RFC 1036ˤ̣򼺤ä
//  Sun Nov  6 08:49:37 1994         ; ANSI Casctime()Υեޥå
//  012345678901234567890123456

static char *MonthName[12]= 
{
    "Jan","Feb","Mar","Apr",
    "May","Jun","Jul","Aug",
    "Sep","Oct","Nov","Dec",
};

long DateStringToDate(char *p)
{
    int month,year,day;
    struct tm tm; 
    int i;

    while(*p==' ')
      p++;

    // ̾ڤ: 
    month=12;
    for(i=0;i<12;i++)
      if(strstr(p,MonthName[i])!=0)
	month=i;
   
    //ǯ
    switch(p[3])
      {
	case ',':      // type 1
	  year=atoi(p+12);
	  day= atoi(p+5);
	  break;
	case ' ':      // type 3
	  year=atoi(p+20);
	  day= atoi(p+8);
	  break;
	default:       // type 2
	  char *s=strchr(p,',');
	  if(s==NULL) return 0;
	  year=atoi(s+9)+1900;            // ˣǯ
	  day= atoi(s+2);
	  break;
      }

    // դû֤ؤѴ
    int monthbase[12]=
      { 0,31,59,90,120,151,  181,212,243,273,304,334};
    day--;

    long thetime=((year-1970)*365+monthbase[month]+day)*24*60*60;
    
    int leap=(year-1969)/4;
    if(((year-1972)%4==0)&&(month>1))    // 뤦ǯ
      leap++;                            // 2400 ǯ˥Хޤ :-) 
    thetime+=leap*24*60*60;              // 뤦ǯ
    thetime-=9*60*60;                    // ܻ
    return thetime;
}

long URLDate(char *head)
{
    char *p;
    p=strstr(head,"Last-modified:");
    if(p==NULL) return 0;
    p+=strlen("Last-modified:");
    
    return DateStringToDate(p);
}

/*  
int main(int argc,char **argv)
{
//    char *url="http://mechatro1.mech.tohoku.ac.jp/homepage-j.html";
//    char *url="http://mechatro1.mech.tohoku.ac.jp/gif/new.gif";
    char *url="http://www.dais.is.tohoku.ac.jp/";
    char *p=HeadURL(url);
    
    time_t t=URLDate(p);
    
    printf("%s%s\n",p,ctime(&t));
    return 0;
}*/
