#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

// ɬפʤäƲ
// #include<sysent.h>

#ifdef __SUNPRO_CC
#include <sysent.h>
#endif

#include "httpdown.h"

// URL ѥޥå
Matching SaveMatch;
Matching URLMatch;


inline char *nowtime(void)
{
    time_t t;
    time(&t);
    return ctime(&t);
}

// λե饰
int Termination=0;

// Httpdown main program

//String AllowURL[MAXAllow];

// FTP ѿ
static char *FTPUser=NULL;
static char *FTPPass=NULL;
static char *FTPProxy=NULL;

// ǥեȥѥɤκ
// Ŭ˺ѤƲ
#include <pwd.h>
char *CreateDefaultPassword(void)
{
    struct passwd *pw;
    int uid;
    char *user;
    uid=getuid();
    pw=getpwuid(uid);
    if(pw==NULL)
      {
	  user="anonymous";
      }
    else
      {
	  user=pw->pw_name;
      }
    char t1[200],t2[200];
    if(gethostname(t1,199)<0)
      strcpy(t1,"unknown");
    sprintf(t2,"%s@%s",user,t1);
    return strdup(t2);
}


// եɤ߹ 
// ѥåƥ
//   㣱٥
int LoadDefinitions(char *file,int &lv)
{
    FILE *fp;
    fp=fopen(file,"r");
    if(fp==NULL)
      return 0;
    
    char buff[1024],combuff[30];
    char url[1024];
    int l;

    while(!feof(fp))
      {
	  if(fgets(buff,1023,fp)==NULL) break;

	  if(buff[0]=='#')
	    continue;
	  if(sscanf(buff,"%s",combuff)!=1)
	    continue;
	  
	  // β
	  if(strcmp(combuff,"start")==0)         // 
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  AddSData(url,URLFind);
		continue;
	    }
	  if(strcmp(combuff,"allow")==0)         // 
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      URLMatch.Add(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"save")==0)         // ե륻
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      SaveMatch.Add(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"level")==0)         // ž٥
	    {
		if(sscanf(buff,"%s %d",combuff,&l)==2)
		  lv=l;
		continue;
	    }
	  if(strcmp(combuff,"reportlevel")==0)   // ٥
	    {
		if(sscanf(buff,"%s %d",combuff,&l)==2)
		  ReportLevel=l;
		continue;
	    }
	  if(strcmp(combuff,"httpproxy")==0)     // http  proxy 
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  SetHTTPProxy(url);
		continue;
	    }
	  if(strcmp(combuff,"ftpproxy")==0)      // ftp  proxy
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      SetFTPProxy(url);
		      FTPProxy=strdup(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"ftpuser")==0)       // ftp login  username
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      if(FTPUser!=NULL)
			free(FTPUser);
		      FTPUser=strdup(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"ftppass")==0)       // ftp login  password
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      if(FTPPass!=NULL)
			free(FTPPass);
		      FTPPass=strdup(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"httpauth")==0)     // http authorization
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  SetHTTPAuthorization(url);
		continue;
	    }

	  // 켰ͼ
	  switch(buff[0])
	    {
	      case 's':
	      case 'S':      // starting url
		if(sscanf(buff+2,"%s",url)!=1) break;
		AddSData(url,URLFind);
		break;

	      case 'r':
	      case 'R':      // rejection url
		if(sscanf(buff+2,"%s",url)!=1) break;
		AddSData(url,URLTerminated);
		break;
		
	      case 'a':
	      case 'A':      // allow pattern
		if(sscanf(buff+2,"%s",url)!=1) break;
		URLMatch.Add(url);
		break;

	      case 'l':
	      case 'L':      // tranfer level
		if(sscanf(buff+2,"%d",&l)!=1) break;
		lv=l;
		break;
	      case 'p':
	      case 'P':
		if(sscanf(buff+2,"%s",url)!=1) break;
		SetHTTPProxy(url);
		fprintf(stderr,"Use proxy %s\n",url);
		break;
	    }
      }
    fclose(fp);
    if(FTPUser==NULL)
      FTPUser=strdup("anonymous");
    if(FTPPass==NULL)
      FTPPass=CreateDefaultPassword();
    
    return lv;
}

extern "C" char *mktemp(char *templ);
// եΥ: temporal==1 ǥȥ
void SaveDefinitions(char *original,int temporal=0)
{
    FILE *src;
    FILE *dest;
    char temp[300];

    if(original==NULL)
      return;

    if(temporal)
      {
	  fprintf(stderr,"--auto backup saving at %s",nowtime());
	  fflush(stdout);
	  sprintf(temp,"%s.tmp",original);
      }
    else
      {
	  strcpy(temp,"HTDXXXXXX");
	  mktemp(temp);
      }

    src=fopen(original,"r");
    dest=fopen(temp,"w");
    if((src==NULL)||(dest==NULL))
      {
	  fprintf(stderr,"Cannot renew definition file\n");
	  return;
      }

    char buff[1024],cmdbuff[300];
    while(!feof(src))
      {
	  if(fgets(buff,1023,src)==NULL) break;
	  if(buff[0]=='>') 
	    continue;
	  if(sscanf(buff,"%s",cmdbuff)!=0)
	    {
		if(strlen(cmdbuff)>1)
		  {
		      fputs(buff,dest);
		      continue;
		  }
	    }
		
	  if(strchr("sSaAlLpP# ",buff[0])!=NULL)
	    fputs(buff,dest);
      }
    fclose(src);
    fprintf(dest,">following lines are automatically generated by httpdown\n");
    
    FileSData(dest);
    fclose(dest);

    // ե̾ѹ
    if(temporal==0)
      {
	  char backup[1024];
	  sprintf(backup,"%s~",original);
	  rename(original,backup);
	  rename(temp,original);
      }
}

void Help(void)
{
    puts("\nhttpdown ver 3.12");
    puts("         file recursive down loader via http or ftp");
    puts("\nHttpdown usage:");
    puts("  httpdown definition-file\n");
    puts("definition-file includes lines such as");
    puts("start URL         : starting URL");
    puts("allow allow_pat   : allow server or user");
    puts("level level       : tranfer level (default:5)");
    puts("reportlevel rv    : reporting level (0:quiet >10: debug)");
    puts("ftpuser user      : username for ftp login (default:anonymous)");
    puts("ftppass password  : password for ftp login (user@yourhost)");
    puts("httpauth id:pass  : HTTP authorization");
    puts("httpproxy proxy   : proxy server for http");
    puts("ftpproxy proxy    : proxy server for ftp");

    puts("r URL             : rejection URL(not transfered)");
    puts("other type of lines are ignored.\n");
    puts("try also 'man httpdown'\n");
} 


// ǥ쥯ȥκƵ ============================================
static int recursive_mkdir(char *dir)
{
    char *p;
    p=strrchr(dir,'/');
    if(p!=NULL) 
      {
	  *p='\0';
	  recursive_mkdir(dir);
	  *p='/';
      }
    return mkdir(dir,0733);
}

// եΥ ===============================================
int SaveFile(char *content,char *url,int size)
{
    int port;
    char *server=URLServer(url,port);
    if(server==NULL) return -1;

    char *file=URLFile(url);
    if(file==NULL)
      {
	  free(server);
	  return -1;
      }
    
    // ִबäơġʤ
    if((!SaveMatch.IsNULL())&&(!SaveMatch.IsMatch(url)))
      return -1; 
      

    char filename[1024];
    sprintf(filename,"%s%s",server,file); // port ϤĤʤǤ
    free(server);
    free(file);

    // ǥ쥯ȥĴ
    char *p;
    p=strrchr(filename,'/');
    if(p!=NULL)
      {
	  *p='\0';
	  char cwd[1024];
	  if(getcwd(cwd,1024)==NULL)
	    {
		fprintf(stderr,"Save: Cannot get current working dir\n");
		return -1;
	    }
	  if(chdir(filename)!=0)
	    recursive_mkdir(filename);
	  chdir(cwd);
	  *p='/';
	  if(*(p+1)=='\0')         // ե̾ '/' ǤäƤ
	    {
		if(URLTypeID(url)==URLFTP)
		  strcat(p,"_dirlist");
		else
		  strcat(p,"_default");
	    }
      }

    FILE *fp=fopen(filename,"wb");
    if(fp==NULL)
      {
	  fprintf(stderr,"Save: File write error '%s'\n",filename);
	  return -1;
      }
    
    fwrite(content,1,size,fp);
    fclose(fp);
    return 0;
}


// եκƵ
void RecursiveGetDocument(int level,char *original)
{
    int i;

    char *url;
    char *content;
    int size;
    int checked=0;
    int parseftp;

    // ftp:// ftp 򤹤뤫ɤ: proxy к
    if((FTPProxy!=NULL)&&(URLTypeID(FTPProxy)==URLHTTP))
      parseftp=0;
    else
      parseftp=1;

    for(i=0;i<level;i++)
      {
	  if(ReportLevel>=0)
	    printf("< Level %d >\n",i);
	  NextLevel(5);
//	  PrintSData();
	  while(1)
	    {
		if(Termination)
		  break;
		url=NextSData();
		if(url==NULL)
		  break;

		// ֤ξ
		if(checked>100)
		  {
		      SaveDefinitions(original,1);
		      checked=0;
		  }
		checked++;

		if(ReportLevel>=0)
		  printf("URL:  %s   Trying\n  ->",url);
		fflush(stdout);

		// Ƥž
		content=GetURL(url,FTPUser,FTPPass,size);
		
		if((content==NULL)||(size==0)) 
		  {
		      if(TransferError>399)
			AddSData(url,URLCannot);  // Բ
		      if(content)
			free(content);
		      continue;
		  }
		if(ReportLevel>=0)
		  printf(" Done. size %d\n",size);
		// ե¸
		if(SaveFile(content,url,size)<0)
		  {
		      AddSData(url,URLRecursive);
		      // ե˥֤ǤʤȤϤʤ
		      ParseContent(content,url,parseftp);
		      free(content);
		      continue;
		  }
		// 
		if(ParseContent(content,url,parseftp))
		  {  // ʬȤơѤ
		      AddSData(url,URLRecursive);
		  }
		else
		  {  // üȤƽ
		      AddSData(url,URLTerminated);
		  }
		free(content);
//		sleep(1);  // ޤᤤž
	    }
	  if(Termination)
	    break;
      }
}

void SigInt(int sig)
{
    fprintf(stderr,"<receive terminate signal(%d) to exit. now waiting>");
    fflush(stdout);
    Termination=1;
}

extern int CreateDefinitions(char *filename);    

// ץβ
int ParseArg(int argc,char **argv,char *&deffile,int &lv)
{
    int l,i;
    for(i=1;i<argc;i++)
      {
	  if(i<argc-1)
	    {
		if(strcmp(argv[i],"-allow")==0)         // 
		  {
		      URLMatch.Add(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-save")==0)         // 
		  {
		      SaveMatch.Add(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-level")==0)         // ž٥
		  {
		      if(sscanf(argv[i+1],"%d",&l)==1)
			lv=l;
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-reportlevel")==0)   // ٥
		  {
		      if(sscanf(argv[i+1],"%d",&l)==1)
			ReportLevel=l;
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-httpproxy")==0)     // http  proxy 
		  {
		      SetHTTPProxy(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-ftpproxy")==0)      // ftp  proxy
		  {
		      SetFTPProxy(argv[i+1]);
		      FTPProxy=strdup(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-ftpuser")==0)     // ftp login  username
		  {
		      if(FTPUser!=NULL)
			free(FTPUser);
		      FTPUser=strdup(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-ftppass")==0)     // ftp login  password
		  {
		      if(FTPPass!=NULL)
			free(FTPPass);
		      FTPPass=strdup(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-httpauth")==0)     // http authorization
		  {
		      SetHTTPAuthorization(argv[i+1]);
		      i++;
		      continue;
		  }
		
		// β
		if(strcmp(argv[i],"-start")==0)         // 
		  {
		      AddSData(argv[i+1],URLFind);
		      i++;
		      continue;
		  }
	    }
		
	  // ե
	  l=LoadDefinitions(argv[i],lv);
	  if(l==0)
	    {
		if(CreateDefinitions(argv[i])==0)
		  Help();
		exit(0);
	    }
	  deffile=strdup(argv[i]);
      }
    return lv;
}

// ~/.httpdownrc Τߤ
void LoadDefaultDefinition(int &lv)
{
    char *env=getenv("HOME");
    if(env==NULL)
      return ;
    char file[300];
    sprintf(file,"%s/.httpdownrc",env);
    FILE *fp;
    fp=fopen(file,"r");
    if(fp==NULL)
      return ;
    fclose(fp);
    LoadDefinitions(file,lv);
}

int main(int argc,char **argv)
{
    Err=stdout;    // 顼
    UserAgent="httpdown 3.0";
    if(argc<2)
      {
	  Help();
	  return 0;
      }
    
    int level=5;

    // եɤ߹
    LoadDefaultDefinition(level);

    char *deffile=NULL;
    level=ParseArg(argc,argv,deffile,level);
    
    signal(SIGHUP ,SigInt);
    signal(SIGQUIT,SigInt);
    signal(SIGTERM,SigInt);
    signal(SIGINT ,SigInt);

    if((ReportLevel>=0)&&(deffile))
      printf("httpdown starts with %s at %s\n",deffile,nowtime());
    RecursiveGetDocument(level,deffile);
    SaveDefinitions(deffile);
    return 0;
}
    
