// URL 갷
//      Ȥꤢftp(with proxy)  http(with proxy) žǽΥݡ

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "url.h"
#include "http.h"
#include "ftp.h"

// ѿ
static char *HTTPProxy=NULL;
static char *FTPProxy=NULL;

int ReportLevel=2,TransferError;
FILE *Err=stderr;

// gethostname ʤк
#ifdef NEED_GETHOSTNAME
#include <sys/utsname.h>

int gethostname(char *name, int namelen)
{
    struct utsname uts;
    int ret = uname(&uts);
    strncpy(name, uts.nodename, namelen);
    return ret;
}
#endif




// URL ʸʬ
void string_lower(char *s)
{
    while(*s)
      {
	  *s=tolower(*s);
	  s++;
      }
}


char *URLType(char *url)
{
    char *p,*q,*r;

    q=strdup(url);
    p=strstr(q,":");
    if(p==NULL)
      {
	  free(q);
	  return NULL;
      }
    *p='\0';
    r=strdup(q);
    free(q);
    string_lower(r);      // ʸ
    return r;
}

int URLTypeID(char *url)
{
    char *r=URLType(url);
    if(r==NULL)
      return URLError;
    int rr=URLError;
    if(strcmp(r,"ftp")==0)
      rr=URLFTP;
    if(strcmp(r,"http")==0)
      rr=URLHTTP;
    free(r);
    return rr;
}

char *URLServer(char *url,int &port)
{
    char *p,*q,*r;

    p=strstr(url,"://");
    if(p==NULL)
      return NULL;
    q=strdup(p+3);
    
    p=strchr(q,'/');
    if(p==NULL)
      {
	  free(q);
	  return NULL;
      }
    *p='\0';
    // ݡֹθ
    if((p=strchr(q,':'))!=NULL)
      {
	  port=atoi(p+1);
	  *p='\0';
      }

    r=strdup(q);
    free(q);
    return r;
}
    
char *URLServerWithType(char *url)
{
    char *p,*q,*r;

    q=strdup(url);
    p=strstr(q,"://");
    if(p==NULL)
      return NULL;

  
    p=strchr(p+3,'/');
    if(p==NULL)
      {
	  free(q);
	  return NULL;
      }
    *p='\0';

    r=strdup(q);
    free(q);
    return r;
}
    
char *URLFile(char *url)
{
    char *p,*r;

    p=strstr(url,"://");
    if(p==NULL)
      return NULL;
    p+=3;

    p=strchr(p,'/');
    if(p==NULL)
      return NULL;
    
    r=strdup(p);
    return r;
}


void SetHTTPProxy(char *proxy)
{
    if(HTTPProxy)
      free(HTTPProxy);
    HTTPProxy=strdup(proxy);
}

void SetFTPProxy(char *proxy)
{
    if(FTPProxy)
      free(FTPProxy);
    FTPProxy=strdup(proxy);
}


// HTTP žproxy Ȥξ櫓
char *GetURLHTTP(char *url,int &size)
{
    char *server,*file;
    int port=80;
    size=0;
    char *r;

    // proxy
    if(HTTPProxy==NULL)
      {  // non-proxy
	  server=URLServer(url,port);
	  file=URLFile(url);
      }
    else
      {  // use proxy
	  server=URLServer(HTTPProxy,port);
	  file=strdup(url);
	  if(ReportLevel>0)
	    printf("<< Use http proxy %s >>",HTTPProxy);
      }

    if((server==NULL)||(file==NULL))
      {
	  if(server) free(server);
	  if(file) free(file);
	  TransferError=TEMisc;
	  return NULL;
      }
    
    r=GetHTTP(server,port,file,size);

    free(file);
    free(server);

    return r;
}

// FTP žproxy ξ櫓
     
char *GetURLFTP(char *url,char *id,char *pass,int &size)
{
    char *server,*file,*actualserver=NULL;
    int port=21;
    size=0;
    char *r;

    // proxy
    if(FTPProxy==NULL)
      {  // non-proxy
	  server=URLServer(url,port);
	  file=URLFile(url);
      }
    else
      {  // use proxy
	  char *type=URLType(FTPProxy);
	  if(type==NULL)
	    return NULL;       // 䤷餵ʤ
	  if(strcmp(type,"http")==0)     // HTTP Proxy ͳ
	    {
		port=80;
		server=URLServer(FTPProxy,port);
		file=strdup(url);
		if((server==NULL)||(file==NULL))
		  {
		      if(server) free(server);
		      if(file) free(file);
		      TransferError=TEMisc;
		      return NULL;
		  }
		
		if(ReportLevel>0)
		  printf("<< Use http proxy %s in ftp>>",FTPProxy);
		r=GetHTTP(server,port,file,size);
		
		free(file);
		free(server);
		
		return r;
	    }
	  if(strcmp(type,"ftp")!=0)
	    return NULL;      // ؤʤ 
	  
	  if(ReportLevel>0)
	    printf("<< Use ftp proxy %s >>",FTPProxy);
	  server=URLServer(FTPProxy,port);
	  file=URLFile(url);
	  int tmp;
	  actualserver=URLServer(url,tmp);
	  //       ftp proxy  //server/file 餷
      }

    if((server==NULL)||(file==NULL))
      {
	  if(server) free(server);
	  if(file) free(file);
	  TransferError=TEMisc;
	  return NULL;
      }
    
    r=GetFTP(server,port,id,pass,file,size,actualserver);

    if(actualserver)
      free(actualserver);
    free(file);
    free(server);

    return r;
}
      

char *GetURL(char *url,char *id,char *pass,int &size)
{
    char *type;
    char *r;

    TransferError=TENoError;

    type=URLType(url);
    if(type==NULL)
      {
	  TransferError=TEMisc;
	  return NULL;
      }

    if(strcmp(type,"http")==0)
      r=GetURLHTTP(url,size);
    else if(strcmp(type,"ftp")==0)
      r=GetURLFTP(url,id,pass,size);
    else
      {
	  fprintf(Err,"Unknown URL type '%s'\n",type);
	  r=NULL;
      }
    free(type);
    return r;
}


