#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "httpdown.h"


char *FTPUser=NULL;
char *FTPPass=NULL;

// ǥեȥѥɤκ
// Ŭ˺ѤƲ
#include <pwd.h>
char *CreateDefaultPassword(void)
{
    struct passwd *pw;
    int uid;
    char *user;
    uid=getuid();
    pw=getpwuid(uid);
    if(pw==NULL)
      {
	  user="anonymous";
      }
    else
      {
	  user=pw->pw_name;
      }
    char t1[200],t2[200];
    if(gethostname(t1,199)<0)
      strcpy(t1,"unknown");
    sprintf(t2,"%s@%s",user,t1);
    return strdup(t2);
}

// եɤ߹ 
// ѥåƥ
//   㣱٥
int LoadDefinitions(char *file)
{
    FILE *fp;
    fp=fopen(file,"r");
    if(fp==NULL)
      return 0;
    
    char buff[1024],combuff[30];
    char url[1024];
    int l;

    while(!feof(fp))
      {
	  if(fgets(buff,1023,fp)==NULL) break;

	  if(buff[0]=='#')
	    continue;
	  if(sscanf(buff,"%s",combuff)!=1)
	    continue;
	  
	  if(strcmp(combuff,"reportlevel")==0)   // ٥
	    {
		if(sscanf(buff,"%s %d",combuff,&l)==2)
		  ReportLevel=l;
		continue;
	    }
	  if(strcmp(combuff,"httpproxy")==0)     // http  proxy 
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  SetHTTPProxy(url);
		continue;
	    }
	  if(strcmp(combuff,"ftpproxy")==0)      // ftp  proxy
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      SetFTPProxy(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"ftpuser")==0)       // ftp login  username
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      if(FTPUser!=NULL)
			free(FTPUser);
		      FTPUser=strdup(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"ftppass")==0)       // ftp login  password
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  {
		      if(FTPPass!=NULL)
			free(FTPPass);
		      FTPPass=strdup(url);
		  }
		continue;
	    }
	  if(strcmp(combuff,"httpauth")==0)     // http authorization
	    {
		if(sscanf(buff,"%s %s",combuff,url)==2)
		  SetHTTPAuthorization(url);
		continue;
	    }
      }
    fclose(fp);
    if(FTPUser==NULL)
      FTPUser=strdup("anonymous");
    if(FTPPass==NULL)
      FTPPass=CreateDefaultPassword();
    
    return 0;
}
// ץβ
char *ParseArg(int argc,char **argv)
{
    char *r=NULL;
    int l,i,ac=0;
    for(i=1;i<argc;i++)
      {
	  if(i<argc-1)
	    {
		if(strcmp(argv[i],"-reportlevel")==0)   // ٥
		  {
		      if(sscanf(argv[i+1],"%d",&l)==1)
			ReportLevel=l;
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-httpproxy")==0)     // http  proxy 
		  {
		      SetHTTPProxy(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-ftpproxy")==0)      // ftp  proxy
		  {
		      SetFTPProxy(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-ftpuser")==0)     // ftp login  username
		  {
		      if(FTPUser!=NULL)
			free(FTPUser);
		      FTPUser=strdup(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-ftppass")==0)     // ftp login  password
		  {
		      if(FTPPass!=NULL)
			free(FTPPass);
		      FTPPass=strdup(argv[i+1]);
		      i++;
		      continue;
		  }
		if(strcmp(argv[i],"-httpauth")==0)     // http authorization
		  {
		      SetHTTPAuthorization(argv[i+1]);
		      i++;
		      continue;
		  }
		
	    }
	  r=argv[i];
      }
    return r;
}

// ~/.httpdownrc Τߤ
void LoadDefaultDefinition(void)
{
    char *env=getenv("HOME");
    if(env==NULL)
      return ;
    char file[300];
    sprintf(file,"%s/.httpdownrc",env);
    FILE *fp;
    fp=fopen(file,"r");
    if(fp==NULL)
      return ;
    fclose(fp);
    LoadDefinitions(file);
}

int main(int argc,char **argv)
{
    ReportLevel=-1;
    LoadDefaultDefinition();
    char *r=ParseArg(argc,argv);
    if(r==NULL)
      {
	  fprintf(stderr,"Please give me URL to transfer\n");
	  return 0;
      }
    int size;
    if(FTPUser==NULL)
      FTPUser=strdup("anonymous");
    if(FTPPass==NULL)
      FTPPass=CreateDefaultPassword();
    char *p=GetURL(r,FTPUser,FTPPass,size);
    if(p==NULL)
      {
	  fprintf(stderr,"Transfer Failed\n");
	  return 0;
      }
    fwrite(p,size,1,stdout);
    free(p);
    return 0;
}
