// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TInputObjectFile.hh"
#include "TStreamableObject.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TDataFilter.hh"

TInputObjectFile::TInputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TInputObjectStream( tFileStream )
{;}


TInputObjectFile::TInputObjectFile( TDataFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TInputObjectStream( filter, tFileStream )
{;}

TInputObjectFile::~TInputObjectFile()
{;}

TStreamableObject* TInputObjectFile::ReadData()
{
  if ( HasFilter() )
    return( theDataFilter -> Analyze( this ) );

  theLastDataSize = theDataSize;
  theDataSize = 0;

  static const Tsize_t sosize = Tsizeof( TStreamableObject );
  static const Tsize_t nmemb = 1;
  static Tobject_t objecttype = tDataUnknown;
  TStreamableObject* s = (TStreamableObject*)( malloc( sosize ) );
  if ( ( fread( s, sosize, nmemb, theFileStream ) != nmemb ) ) {
    objecttype = tDataUnknown;
    free( s );
  } else {
    objecttype = s -> GetObjectType();
    free( s );
    SetOffset( -sosize );
  }

  switch ( objecttype ) {
    case tDataRecord:
      return( getDataRecord() );
    case tDataSection:
      return( getDataSection() );
    case tDataSegment:
      return( getDataSegment() );
    case tDataElement:
      return( getDataElement() );
    case tDataUnknown:
    default:
      return( 0 );
  }
}

TDataRecord* TInputObjectFile::getDataRecord()
{
  static const Tsize_t recordSize = Tsizeof( TDataRecord );
  static const Tsize_t nmemb = 1;
  TDataRecord* record = (TDataRecord*)( malloc( recordSize ) );
  if ( ( fread( record, recordSize, nmemb, theFileStream ) != nmemb ) )
    return( 0 );

  theDataSize += recordSize;
  Tint entries = record -> GetNumberOfEntries();
  Tint capacity = record -> GetCapacity();
  Tint id = record -> GetID();
  free( record );

  TDataRecord* r = new TDataRecord( id, capacity );
  for ( Tint i = 0; i < entries; i ++ )
    r -> Add( getDataSection() );

  return( r );
}

TDataSection* TInputObjectFile::getDataSection()
{
  static const Tsize_t sectionSize = sizeof( TDataSection );
  static const Tsize_t nmemb = 1;
  TDataSection* section = (TDataSection*)( malloc( sectionSize ) );
  if ( ( fread( section, sectionSize, nmemb, theFileStream ) != nmemb ) )
    return( 0 );

  theDataSize += sectionSize;
  Tint entries = section -> GetNumberOfEntries();
  Tint capacity = section -> GetCapacity();
  Tint id = section -> GetID();
  free( section );

  TDataSection* s = new TDataSection( id, capacity );
  for ( Tint i = 0; i < entries; i ++ )
    s -> Add( getDataSegment() );

  return( s );
}

TDataSegment* TInputObjectFile::getDataSegment()
{
  static const Tsize_t segmentSize = sizeof( TDataSegment );
  static const Tsize_t nmemb = 1;
  TDataSegment* segment = (TDataSegment*)( malloc( segmentSize ) );
  if ( ( fread( segment, segmentSize, nmemb, theFileStream ) != nmemb ) )
    return( 0 );

  theDataSize += segmentSize;
  Tint entries = segment -> GetNumberOfEntries();
  Tint capacity = segment -> GetCapacity();
  Tint id = segment -> GetID();
  free( segment );

  TDataSegment* s = new TDataSegment( id, capacity );
  for ( Tint i = 0; i < entries; i ++ )
    s -> Add( getDataElement() );

  return( s );
}

TDataElement* TInputObjectFile::getDataElement()
{

  static const Tsize_t elementSize = sizeof( TDataElement );
  static const Tsize_t nmemb = 1;
  TDataElement* element = (TDataElement*)( malloc( elementSize ) );

  if ( ( fread( element, elementSize, nmemb, theFileStream ) != nmemb ) )
    return( 0 );
  theDataSize += elementSize;

  Telement_t eltype = element -> GetElementType();
  Tint id = element -> GetID();
  Tsize_t nprimitives = (Tsize_t)( element -> GetNumberOfPrimitives() );

  free( element );

  Tstring s;
  Tchar* c = new Tchar[ nprimitives ];
  Tint* i = new Tint[ nprimitives ];
  Tdouble* d = new Tdouble[ nprimitives ];
  Tvoid* data = 0;

  switch ( eltype ) {
    case tTypeString:
      fread( c, Tsizeof( Tchar ), nprimitives, theFileStream );
      s = c;
      data = &s;
      theDataSize += (Tint)( Tsizeof( Tchar ) * nprimitives );
      break;
    case tTypeDouble:
      fread( d, Tsizeof( Tdouble ), nmemb, theFileStream );
      data = d;
      theDataSize += (Tint)( Tsizeof( Tdouble ) * nmemb );
      break;
    case tTypeInt:
      fread( i, Tsizeof( Tint ), nmemb, theFileStream );
      data = i;
      theDataSize += (Tint)( Tsizeof( Tint ) * nmemb );
      break;
    case tTypeUnknown:
    case tTypeObject:
    case tTypeFloat:
    default:
      break;
  }

  TDataElement* e = new TDataElement( data, eltype, id );

  delete [] c;
  delete [] i;
  delete [] d;

  return( e );
}
