// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TMODULE_HH
#define __TMODULE_HH

#include "TGlobals.hh"

class TDataSegment;
class TDataElement;

class TModule
{

  protected:
    enum { tStatusSuccess = 0 };

  protected:
    Tint theNumberOfChannels;
    Tint theID;
    Tint theStatus;

  public:
    virtual Tint Clear() = 0;
    virtual Tint Update() = 0;
    virtual Tint Initialize() = 0;
    virtual Tvoid FillData( TDataSegment* seg ) = 0;
    virtual Tvoid FillData( TDataElement* ele ) = 0;

  public:
    inline virtual Tvoid Print( Tostream& tos = Tstd::Tcout ) const;

  public:
    TModule( Tint nchannel, Tint id = tIDunknown, Tint status = tStatusSuccess );

  protected:
    virtual ~TModule();

  public:
    inline Tint GetNumberOfChannels() const;
    inline Tint GetStatus() const;
    inline Tint GetID() const;
    inline Tvoid SetNumberOfChannels( Tint nchannel );
    inline Tvoid SetStatus( Tint status );
    inline Tvoid SetID( Tint id );

    inline Tbool IsSuccess() const;
};

inline Tint TModule::GetNumberOfChannels() const
{
  return( theNumberOfChannels );
}

inline Tvoid TModule::SetNumberOfChannels( Tint nchannel )
{
  theNumberOfChannels = nchannel;
  return;
}

inline Tint TModule::GetID() const
{
  return( theID );
}

inline Tvoid TModule::SetID( Tint id )
{
  theID = id;
  return;
}

inline Tint TModule::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TModule::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tbool TModule::IsSuccess() const
{
  return( ( theStatus >= 0 ) ? Ttrue : Tfalse );
}

inline Tvoid TModule::Print( Tostream& tos ) const
{
  Tstring head = "* Module, ";
  tos << head << "Status: " << theStatus << Tendl;
  return;
}

#endif
