// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOBJECTSTREAM_HH
#define __TOBJECTSTREAM_HH

#include "TGlobals.hh"

class TDataFilter;

class TObjectStream
{

  protected:
    TDataFilter* theDataFilter;
    Tstream_t theStreamType;
    Tint theDataSize;
    Tint theLastDataSize;

  public:
    TObjectStream( Tstream_t streamtype = tUnknownStream );
    TObjectStream( TDataFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TObjectStream();

  public:
    inline Tstream_t GetStreamType() const;
    inline Tvoid SetStreamType( Tstream_t streamtype );

    inline TDataFilter* GetDataFilter() const;
    inline Tvoid SetDataFilter( TDataFilter* filter );
    inline Tbool HasFilter() const;

    inline Tint GetDataSize() const;
    inline Tint GetLastDataSize() const;

    inline Tvoid SetDataSize( Tint datasize );
    inline Tvoid SetLastDataSize( Tint datasize );

};

inline Tint TObjectStream::GetDataSize() const
{
  return( theDataSize );
}

inline Tint TObjectStream::GetLastDataSize() const
{
  return( theLastDataSize );
}

inline Tvoid TObjectStream::SetDataSize( Tint datasize )
{
  theDataSize = datasize;
  return;
}

inline Tvoid TObjectStream::SetLastDataSize( Tint datasize )
{
  theLastDataSize = datasize;
  return;
}

inline Tstream_t TObjectStream::GetStreamType() const
{
  return( theStreamType );
}

inline Tvoid TObjectStream::SetStreamType( Tstream_t streamtype )
{
  theStreamType = streamtype;
  return;
}

inline TDataFilter* TObjectStream::GetDataFilter() const
{
  return( theDataFilter );
}

inline Tvoid TObjectStream::SetDataFilter( TDataFilter* filter )
{
  theDataFilter = filter;
  return;
}

inline Tbool TObjectStream::HasFilter() const
{
  return( ( theDataFilter != 0 ) ? Ttrue : Tfalse );
}

#endif
