// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadoutElement.hh"
#include "TModule.hh"
#include "TDataElement.hh"

TReadoutElement::TReadoutElement( TModule* module, Tint channelNumber )
  : theModule( module ), theChannelNumber( channelNumber )
{;}

TReadoutElement::~TReadoutElement()
{;}

Tvoid TReadoutElement::Print( Tostream& tos )
{
  Tstring head = Twspace + Twspace + Twspace + "* Readout Element, ";
  tos << head << "Channel: " << theChannelNumber << Tendl;
  theModule -> Print( tos );
  return;
}

TDataElement* TReadoutElement::ReadData()
{
  TDataElement* d = new TDataElement( tTypeUnknown, theChannelNumber );
  theModule -> FillData( d );

  return( d );
}
