// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TREADOUTELEMENT_HH
#define __TREADOUTELEMENT_HH

#include "TGlobals.hh"

class TDataElement;
class TModule;

class TReadoutElement
{

  private:
    TModule* theModule;
    Tint theChannelNumber;

  public:
    TReadoutElement( TModule* module, Tint channelNumber = tIDunknown );
    ~TReadoutElement();

    Tvoid Print( Tostream& tos = Tstd::Tcout );
    TDataElement* ReadData();

  public:
    inline Tint GetChannelNumber() const;
    inline Tvoid SetChannelNumber( Tint channelNumber );
    inline TModule* GetModule() const;
    inline Tvoid SetModule( TModule* module );

};

inline TModule* TReadoutElement::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutElement::SetModule( TModule* module )
{
  theModule = module;
  return;
}

inline Tint TReadoutElement::GetChannelNumber() const
{
  return( theChannelNumber );
}

inline Tvoid TReadoutElement::SetChannelNumber( Tint channelNumber )
{
  theChannelNumber = channelNumber;
  return;
}

#endif
