// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadoutSection.hh"
#include "TDataSection.hh"
#include "TReadoutSegment.hh"

TReadoutSection::TReadoutSection( Tint id, Tint capacity )
  : TReadoutSegmentList( capacity, tDefaultReallocationParameter ), theID( id )
{;}

TReadoutSection::~TReadoutSection()
{;}

Tvoid TReadoutSection::Print( Tostream& tos )
{
  Tstring head = Twspace + "* Readout Section, ";
  tos << head << "ID: " << theID;
  tos << Twspace << "Capacity: " << theCapacity;
  tos << Twspace << "Entry: " << theNumberOfEntries << Tendl;

  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    theObjects[ i ] -> Print( tos );

  return;
}

TDataSection* TReadoutSection::ReadData()
{
  TDataSection* d = new TDataSection( theID, theNumberOfEntries );
  TReadoutSegment* seg = 0;

  SetPosition( 0 );
  while ( ( seg = Next() ) )
    d -> Add( seg -> ReadData() );

  return( d );
}
