// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TREADOUTSECTION_HH
#define __TREADOUTSECTION_HH

#include "TGlobals.hh"
#include "TReadoutSegmentList.hh"

class TDataSection;

class TReadoutSection
  : public TReadoutSegmentList
{

  private:
    Tint theID;

  public:
    TReadoutSection( Tint id = tIDunknown, Tint capacity = tDefaultCapacity );
    ~TReadoutSection();

    Tvoid Print( Tostream& tos = Tstd::Tcout );
    TDataSection* ReadData();

  public:
    inline Tint GetID() const;
    inline Tvoid SetID( Tint id );

};

inline Tint TReadoutSection::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutSection::SetID( Tint id )
{
  theID = id;
  return;
}

#endif
