// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadoutSegment.hh"
#include "TModule.hh"
#include "TDataSegment.hh"

TReadoutSegment::TReadoutSegment( Tint id, Tint capacity )
  : TReadoutElementList( capacity, tDefaultReallocationParameter ),
    theID( id ), theModule( 0 )
{;}

TReadoutSegment::TReadoutSegment( TModule* module, Tint id, Tint capacity )
  : TReadoutElementList( capacity, tDefaultReallocationParameter ),
    theID( id ), theModule( module )
{;}

TReadoutSegment::~TReadoutSegment()
{;}

Tvoid TReadoutSegment::Print( Tostream& tos )
{
  Tstring head = Twspace + Twspace + "* Readout Segment, ";
  tos << head << "ID: " << theID;
  tos << Twspace << "Capacity: " << theCapacity;
  tos << Twspace << "Entry: " << theNumberOfEntries << Tendl;

  if ( theModule == 0 )
    for ( Tint i = 0; i < theNumberOfEntries; i ++ )
      theObjects[ i ] -> Print( tos );
  else
    theModule -> Print( tos );

  return;
}

TDataSegment* TReadoutSegment::ReadData()
{
  TDataSegment* d = new TDataSegment( theID, theNumberOfEntries );
  if ( theModule == 0 ) {
    TReadoutElement* ele = 0;
    SetPosition( 0 );
    while ( ( ele = Next() ) )
      d -> Add( ele -> ReadData() );
  } else {
    theModule -> FillData( d );
  }

  return( d );
}
