// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TREADOUTSEGMENT_HH
#define __TREADOUTSEGMENT_HH

#include "TGlobals.hh"
#include "TReadoutElementList.hh"

class TModule;
class TDataSegment;

class TReadoutSegment
  : public TReadoutElementList
{

  private:
    Tint theID;
    TModule* theModule;

  public:
    TReadoutSegment( Tint id = tIDunknown, Tint capacity = tDefaultCapacity );
    TReadoutSegment( TModule* module, Tint id = tIDunknown, Tint capacity = tDefaultCapacity );
    ~TReadoutSegment();

    Tvoid Print( Tostream& tos = Tstd::Tcout );
    TDataSegment* ReadData();

  public:
    inline Tint GetID() const;
    inline Tvoid SetID( Tint id );
    inline TModule* GetModule() const;
    inline Tvoid SetModule( TModule* module );

};

inline Tint TReadoutSegment::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutSegment::SetID( Tint id )
{
  theID = id;
  return;
}

inline TModule* TReadoutSegment::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutSegment::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
