// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSOFTWAREADCMODULE_HH
#define __TSOFTWAREADCMODULE_HH

#include "TGlobals.hh"
#include "TSoftwareModule.hh"
#include "TChannel.hh"
#include "TRandomEngine.hh"
#include "TRandomFlat.hh"
#include "TRandomGaussian.hh"

class TDataSegment;
class TDataElement;

class TSoftwareAdcModule
  : public TSoftwareModule
{
  protected:
    enum { tDataOverFlow = -1 };
    enum { tDefaultScale = 4095 };
    enum { tDefaultChannel = 8 };

  protected:
    Tint theScale;
    Tint* theMean;
    Tint* theSigma;
    TChannel* theChannel;
    TRandomFlat theRandomFlat;
    TRandomGaussian theRandomGaussian;

  public:
    static Tlong theSeed;
    static TRandomEngine theRandomEngine;

  public:
    TSoftwareAdcModule( Tint nchannel = tDefaultChannel,
			Tint scale = tDefaultScale,
			Tint id = tIDunknown );

    virtual ~TSoftwareAdcModule();

  public:
    virtual Tint Clear();
    virtual Tint Update();
    virtual Tint Initialize();

    virtual Tvoid FillData( TDataSegment* seg );
    virtual Tvoid FillData( TDataElement* ele );

  public:
    inline virtual Tvoid Print( Tostream& tos = Tstd::Tcout ) const;

  protected:
    virtual Tvoid setParameters();

  public:
    inline virtual const TChannel* GetChannel() const;
    inline virtual Tint GetScale() const;
    inline virtual Tint GetMean( Tint channel = 0 ) const;
    inline virtual Tint GetSigma( Tint channel = 0 ) const;
    inline virtual Tvoid SetScale( Tint scale );
    inline virtual Tint GetData( Tint channel ) const;

};

inline Tint TSoftwareAdcModule::GetData( Tint channel ) const
{
  if ( channel < 0 || ( channel >= theChannel -> GetNumberOfEntries() ) )
    return( -EFAULT );
  return( *( theChannel -> Get( channel ) ) );
}

inline const TChannel* TSoftwareAdcModule::GetChannel() const
{
  return( theChannel );
}

inline Tint TSoftwareAdcModule::GetScale() const
{
  return( theScale );
}

inline Tint TSoftwareAdcModule::GetMean( Tint channel ) const
{
  if ( channel < 0 || ( channel >= theChannel -> GetNumberOfEntries() ) )
    return( -EFAULT );
  return( theMean[ channel ] );
}

inline Tint TSoftwareAdcModule::GetSigma( Tint channel ) const
{
  if ( channel < 0 || ( channel >= theChannel -> GetNumberOfEntries() ) )
    return( -EFAULT );
  return( theSigma[ channel ] );
}

inline Tvoid TSoftwareAdcModule::SetScale( Tint scale )
{
  theScale = scale;
  return;
}

#endif
