// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSoftwareClockModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

Tstring TSoftwareClockModule::theCompleteTimeFormat = "%Y/%m/%d %a %H:%M:%S %z %Z";

TSoftwareClockModule::TSoftwareClockModule( Tint nchannel, Tint id )
  : TSoftwareModule( nchannel, tStatusSuccess, id ), thePastTimeSice1970( 0 )
{
  setCurrentTime();
}

TSoftwareClockModule::~TSoftwareClockModule()
{;}


Tint TSoftwareClockModule::Clear()
{
  thePastTimeSice1970 = 0;
  theCompleteTime.erase();
  theLocalYear.erase();
  theLocalMonth.erase();
  theLocalDate.erase();
  theLocalDay.erase();
  theLocalHour.erase();
  theLocalMinute.erase();
  theLocalSecond.erase();
  theLocalTimeZone.erase();
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareClockModule::Update()
{
  setCurrentTime();
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareClockModule::Initialize()
{
  Clear();
  SetCompleteTimeFormat( "%Y/%m/%d %a %H:%M:%S %z %Z" );
  return( theStatus = tStatusSuccess );
}

Tvoid TSoftwareClockModule::FillData( TDataSegment* segment )
{
  segment -> Add( new TDataElement( &thePastTimeSice1970, tTypeInt, tPastTimeSice1970  ) );
  for ( Tint i = tCompleteTime; i < theNumberOfChannels; i ++ ) {
    Tstring str = getStringData( i );
    segment -> Add( new TDataElement( &str, tTypeString, i ) );
  }
  return;
}

Tvoid TSoftwareClockModule::FillData( TDataElement* element )
{
  Tint ch = element -> GetID();
  if ( ch < 0 || ( ch >= theNumberOfChannels ) ) {
    Tint tmp = -EFAULT;
    element -> FillData( &tmp, tTypeInt );
  } else if ( ch == tPastTimeSice1970 ) {
    element -> FillData( &thePastTimeSice1970, tTypeInt );
  } else {
    Tstring str = getStringData( ch );
    element -> FillData( &str, tTypeString );
  }
  return;
}

Tvoid TSoftwareClockModule::Print( Tostream& tos ) const
{
  Tstring head = Twspace + Twspace + Twspace + "* Software Clock, ";
  tos << head << "Status: " << theStatus << Twspace;
  tos << "ID: " << theID << Tendl;

  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    tos << Twspace << head << "Channel: " << i;
    switch ( i ) {
      case tPastTimeSice1970: 
	tos << Twspace << "Past: " << thePastTimeSice1970 << Tendl;
	break;
      case tCompleteTime: 
	tos << Twspace << "Time: " << theCompleteTime << Tendl;
	break;
      case tCompleteTimeFormat: 
	tos << Twspace << "Format: " << TSoftwareClockModule::theCompleteTimeFormat << Tendl;
	break;
      case tLocalYear:
	tos << Twspace << "Year: " << theLocalYear << Tendl;
	break;
      case tLocalMonth:
	tos << Twspace << "Month: " << theLocalMonth << Tendl;
	break;
      case tLocalDate:
	tos << Twspace << "Date: " << theLocalDate << Tendl;
	break;
      case tLocalDay:
	tos << Twspace << "Day: " << theLocalDay << Tendl;
	break;
      case tLocalHour:
	tos << Twspace << "Hour: " << theLocalHour << Tendl;
	break;
      case tLocalMinute:
	tos << Twspace << "Minute: " << theLocalMinute << Tendl;
	break;
      case tLocalSecond:
	tos << Twspace << "Second: " << theLocalSecond << Tendl;
	break;
      case tLocalTimeZone:
	tos << Twspace << "Time Zone: " << theLocalTimeZone << Tendl;
	break;
    }
  }

  return;
}

Tvoid TSoftwareClockModule::setCurrentTime()
{
  Ttime_t time_now = 0;
  thePastTimeSice1970 = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );

  Tchar* c = new Tchar[ (size_t)tMaxStringLength ];

  strftime( c, (Tsize_t)tMaxStringLength, theCompleteTimeFormat.data(), tm_now );
  theCompleteTime = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%Y", tm_now );
  theLocalYear = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%B", tm_now );
  theLocalMonth = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%d", tm_now );
  theLocalDate = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%A", tm_now );
  theLocalDay = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%H", tm_now );
  theLocalHour = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%M", tm_now );
  theLocalMinute = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%S", tm_now );
  theLocalSecond = c;
  strftime( c, (Tsize_t)tMaxStringLength, "%Z", tm_now );
  theLocalTimeZone = c;

  delete [] c;
  return;
}

const Tstring& TSoftwareClockModule::getStringData( Tint channel ) const
{
  switch( channel ) {
    case tCompleteTime:
      return( theCompleteTime );
    case tCompleteTimeFormat:
      return( TSoftwareClockModule::theCompleteTimeFormat );
    case tLocalYear:
      return( theLocalYear );
    case tLocalMonth:
      return( theLocalMonth );
    case tLocalDate:
      return( theLocalDate );
    case tLocalDay:
      return( theLocalDay );
    case tLocalHour:
      return( theLocalHour );
    case tLocalMinute:
      return( theLocalMinute );
    case tLocalSecond:
      return( theLocalSecond );
    case tLocalTimeZone:
      return( theLocalTimeZone );
    default:
      return( theCompleteTime );
  }
}
