// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSOFTWARECLOCKMODULE_HH
#define __TSOFTWARECLOCKMODULE_HH

#include "TGlobals.hh"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareClockModule
  : public TSoftwareModule
{
  public:
    enum { 
      tPastTimeSice1970, 
      tCompleteTime, 
      tCompleteTimeFormat, 
      tLocalYear,
      tLocalMonth,
      tLocalDate,
      tLocalDay,
      tLocalHour,
      tLocalMinute,
      tLocalSecond,
      tLocalTimeZone,
      tNumberOfChannels
    };

  private:
    enum { tMaxStringLength = 256 };

  private:
    Tint thePastTimeSice1970;
    Tstring theCompleteTime;
    static Tstring theCompleteTimeFormat;
    Tstring theLocalYear;
    Tstring theLocalMonth;
    Tstring theLocalDate;
    Tstring theLocalDay;
    Tstring theLocalHour;
    Tstring theLocalMinute;
    Tstring theLocalSecond;
    Tstring theLocalTimeZone;

  public:
    TSoftwareClockModule( Tint nchannel = tNumberOfChannels, Tint id = tIDunknown );
    ~TSoftwareClockModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();

    Tvoid FillData( TDataSegment* seg );
    Tvoid FillData( TDataElement* ele );

    Tvoid Print( Tostream& tos = Tstd::Tcout ) const;

  public:
    inline Tint GetPastTimeSice1970() const;
    inline const Tstring& GetCompleteTime() const;
    inline const Tstring& GetLocalYear() const;
    inline const Tstring& GetLocalMonth() const;
    inline const Tstring& GetLocalDate() const;
    inline const Tstring& GetLocalDay() const;
    inline const Tstring& GetLocalHour() const;
    inline const Tstring& GetLocalMinute() const;
    inline const Tstring& GetLocalSecond() const;
    inline const Tstring& GetLocalTimeZone() const;
    inline Tvoid SetPastTimeSice1970( Tint pasttime );
    inline Tvoid SetCompleteTime( const Tstring& time );
    inline Tvoid SetLocalYear( const Tstring& year );
    inline Tvoid SetLocalMonth( const Tstring& month );
    inline Tvoid SetLocalDate( const Tstring& date );
    inline Tvoid SetLocalDay( const Tstring& day );
    inline Tvoid SetLocalHour( const Tstring& hour );
    inline Tvoid SetLocalMinute( const Tstring& minute );
    inline Tvoid SetLocalSecond( const Tstring& second );
    inline Tvoid SetLocalTimeZone( const Tstring& zone );

  public:
    inline static const Tstring& GetCompleteTimeFormat();
    inline static Tvoid SetCompleteTimeFormat( const Tstring& format );

  private:
    Tvoid setCurrentTime();
    const Tstring& getStringData( Tint channel ) const;

};

inline const Tstring& TSoftwareClockModule::GetCompleteTimeFormat()
{
  return( TSoftwareClockModule::theCompleteTimeFormat );
}

inline Tvoid TSoftwareClockModule::SetCompleteTimeFormat( const Tstring& format )
{
  TSoftwareClockModule::theCompleteTimeFormat = format;
  return;
}

inline Tint TSoftwareClockModule::GetPastTimeSice1970() const
{
  return( thePastTimeSice1970 );
}

inline const Tstring& TSoftwareClockModule::GetCompleteTime() const
{
  return( theCompleteTime );
}

inline const Tstring& TSoftwareClockModule::GetLocalYear() const
{
  return( theLocalYear );
}

inline const Tstring& TSoftwareClockModule::GetLocalMonth() const
{
  return( theLocalMonth );
}

inline const Tstring& TSoftwareClockModule::GetLocalDate() const
{
  return( theLocalDate );
}

inline const Tstring& TSoftwareClockModule::GetLocalDay() const
{
  return( theLocalDay );
}

inline const Tstring& TSoftwareClockModule::GetLocalHour() const
{
  return( theLocalHour );
}

inline const Tstring& TSoftwareClockModule::GetLocalMinute() const
{
  return( theLocalMinute );
}

inline const Tstring& TSoftwareClockModule::GetLocalSecond() const
{
  return( theLocalSecond );
}

inline const Tstring& TSoftwareClockModule::GetLocalTimeZone() const
{
  return( theLocalTimeZone );
}

inline Tvoid TSoftwareClockModule::SetPastTimeSice1970( Tint pasttime )
{
  thePastTimeSice1970 = pasttime;
  return;
}

inline Tvoid TSoftwareClockModule::SetCompleteTime( const Tstring& time )
{
  theCompleteTime = time;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalYear( const Tstring& year )
{
  theLocalYear = year;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalMonth( const Tstring& month )
{
  theLocalMonth = month;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalDate( const Tstring& date )
{
  theLocalDate = date;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalDay( const Tstring& day )
{
  theLocalDay = day;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalHour( const Tstring& hour )
{
  theLocalHour = hour;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalMinute( const Tstring& minute )
{
  theLocalMinute = minute;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalSecond( const Tstring& second )
{
  theLocalSecond = second;
  return;
}

inline Tvoid TSoftwareClockModule::SetLocalTimeZone( const Tstring& zone )
{
  theLocalTimeZone = zone;
  return;
}

#endif
