// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSOFTWAREMODULE_HH
#define __TSOFTWAREMODULE_HH

#include "TGlobals.hh"
#include "TModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareModule
  : public TModule
{

  public:
    TSoftwareModule( Tint nchannel, Tint status = tStatusSuccess, Tint id = tIDunknown );

  protected:
    virtual ~TSoftwareModule();

  public:
    inline virtual Tvoid Print( Tostream& tos = Tstd::Tcout ) const;

  public:
    virtual Tint Clear() = 0;
    virtual Tint Update() = 0;
    virtual Tint Initialize() = 0;

    virtual Tvoid FillData( TDataSegment* seg ) = 0;
    virtual Tvoid FillData( TDataElement* ele ) = 0;

};

inline Tvoid TSoftwareModule::Print( Tostream& tos ) const
{
  Tstring head = "* Software Module, ";
  tos << head << "Status: " << theStatus << Tendl;
  return;
}

#endif
