// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSoftwareScalerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareScalerModule::TSoftwareScalerModule( Tint nchannel, Tint id )
  : TSoftwareModule( nchannel, tStatusSuccess, id )
{
  theChannel = new TChannel( theNumberOfChannels );
  for ( Tint i = 0; i < theNumberOfChannels; i ++ )
    theChannel -> Add( new Tint( 0 ) );
}

TSoftwareScalerModule::~TSoftwareScalerModule()
{
  delete theChannel;
}

Tvoid TSoftwareScalerModule::FillData( TDataSegment* segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ )
    segment -> Add( new TDataElement( theChannel -> Get( i ), tTypeInt, i ) );
  return;
}

Tvoid TSoftwareScalerModule::FillData( TDataElement* element )
{
  Tint ch = element -> GetID();
  if ( ch < 0 || ( ch >= theChannel -> GetNumberOfEntries() ) ) {
    Tint tmp = -EFAULT;
    element -> FillData( &tmp, tTypeInt );
  } else {
    element -> FillData( theChannel -> Get( ch ), tTypeInt );
  }
  return;
}

Tvoid TSoftwareScalerModule::Print( Tostream& tos ) const
{
  Tstring head = Twspace + Twspace + Twspace + "* Software Scaler, ";
  tos << head << "Status: " << theStatus << Twspace;
  tos << "ID: " << theID << Tendl;

  head = Twspace + head;
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    tos << head << "Channel: " << i;
    tos << Twspace << "Data: " << *( theChannel -> Get( i ) ) << Tendl;
  }

  return;
}
