// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSOFTWARESCALERMODULE_HH
#define __TSOFTWARESCALERMODULE_HH

#include "TGlobals.hh"
#include "TSoftwareModule.hh"
#include "TChannel.hh"

class TDataSegment;
class TDataElement;

class TSoftwareScalerModule
  : public TSoftwareModule
{

  protected:
    enum { tDefaultChannel = 8 };

  protected:
    TChannel* theChannel;

  public:
    TSoftwareScalerModule( Tint nchannel = tDefaultChannel, Tint id = tIDunknown );
    virtual ~TSoftwareScalerModule();

  public:
    inline virtual Tint Clear();
    inline virtual Tint Update();
    inline virtual Tint Initialize();

    virtual Tvoid FillData( TDataSegment* seg );
    virtual Tvoid FillData( TDataElement* ele );
    virtual Tvoid Print( Tostream& tos = Tstd::Tcout ) const;

  public:
    inline virtual Tint Increase( Tint channel );
    inline virtual Tint Increase();
    inline virtual Tint Decrease( Tint channel );
    inline virtual Tint Decrease();
    inline virtual Tint GetData( Tint channel ) const;
    inline virtual Tvoid SetData( Tint channel, Tint data ) const;

  public:
    inline virtual const TChannel* GetChannel() const;

};

inline Tint TSoftwareScalerModule::GetData( Tint channel ) const
{
  if ( channel < 0 || ( channel >= theChannel -> GetNumberOfEntries() ) )
    return( -EFAULT );
  return( *( theChannel -> Get( channel ) ) );
}

inline Tvoid TSoftwareScalerModule::SetData( Tint channel, Tint data ) const
{
  if ( channel < 0 || ( channel >= theChannel -> GetNumberOfEntries() ) )
    return;
  *( theChannel -> Get( channel ) ) = data;
  return;
}

inline const TChannel* TSoftwareScalerModule::GetChannel() const
{
  return( theChannel );
}

inline Tint TSoftwareScalerModule::Increase( Tint channel )
{
  if ( channel < 0 || ( channel >= theChannel -> GetNumberOfEntries() ) )
    return( theStatus = -EFAULT );
  Tint data = GetData( channel );
  SetData( channel, ++ data );
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareScalerModule::Decrease( Tint channel )
{
  if ( channel < 0 || ( channel >= theChannel -> GetNumberOfEntries() ) )
    return( theStatus = -EFAULT );
  Tint data = GetData( channel );
  SetData( channel, -- data );
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareScalerModule::Increase()
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ )
    Increase( i );
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareScalerModule::Decrease()
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ )
    Decrease( i );
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareScalerModule::Clear()
{
  theChannel -> Clear();
  for ( Tint i = 0; i < theNumberOfChannels; i ++ )
    theChannel -> Add( new Tint( 0 ) );
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareScalerModule::Update()
{
  return( Increase() );
}

inline Tint TSoftwareScalerModule::Initialize()
{
  return( Clear() );
}

#endif
