// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSOFTWARETIMERMODULE_HH
#define __TSOFTWARETIMERMODULE_HH

#include "TGlobals.hh"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareTimerModule
  : public TSoftwareModule
{

  public:
    enum { 
      tIntervalTime,
      tCurrentTime, 
      tPreviousTime, 
      tUnit,
      tNumberOfChannels
    };

  private:
    Tdouble theIntervalTime;
    Tdouble theCurrentTime;
    Tdouble thePreviousTime;
    Tstring theUnit;

  public:
    TSoftwareTimerModule( const Tstring& unit = Tmsec, 
			  Tint nchannel = tNumberOfChannels, 
			  Tint id = tIDunknown );
    ~TSoftwareTimerModule();

  public:
    inline Tint Clear();
    inline Tint Update();
    inline Tint Initialize();

  public:
    Tvoid FillData( TDataSegment* seg );
    Tvoid FillData( TDataElement* ele );
    Tvoid Print( Tostream& tos = Tstd::Tcout ) const;

  public:
    inline Tdouble GetIntervalTime() const;
    inline Tdouble GetCurrentTime() const;
    inline Tdouble GetPreviousTime() const;
    inline const Tstring& GetUnit() const;

    inline Tvoid SetIntervalTime( Tdouble interval );
    inline Tvoid SetCurrentTime( Tdouble current );
    inline Tvoid SetPreviousTime( Tdouble previous );
    inline Tvoid SetUnit( const Tstring& unit );

  private:
    Tvoid setCurrentTime();

};

inline Tdouble TSoftwareTimerModule::GetIntervalTime() const
{
  return( theIntervalTime );
}

inline Tdouble TSoftwareTimerModule::GetCurrentTime() const
{
  return( theCurrentTime );
}

inline Tdouble TSoftwareTimerModule::GetPreviousTime() const
{
  return( thePreviousTime );
}

inline const Tstring& TSoftwareTimerModule::GetUnit() const
{
  return( theUnit );
}

inline Tvoid TSoftwareTimerModule::SetIntervalTime( Tdouble interval )
{
  theIntervalTime = interval;
  return;
}

inline Tvoid TSoftwareTimerModule::SetCurrentTime( Tdouble current )
{
  theCurrentTime = current;
  return;
}

inline Tvoid TSoftwareTimerModule::SetPreviousTime( Tdouble previous )
{
  thePreviousTime = previous;
  return;
}

inline Tvoid TSoftwareTimerModule::SetUnit( const Tstring& unit )
{
  if ( unit == Tsec || unit == Tmsec || unit == Tusec )
    theUnit = unit;
  return;
}

inline Tint TSoftwareTimerModule::Clear()
{
  theIntervalTime = 0.0;
  theCurrentTime = 0.0;
  thePreviousTime = 0.0;
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareTimerModule::Update()
{
  setCurrentTime();
  return( theStatus = tStatusSuccess );
}

inline Tint TSoftwareTimerModule::Initialize()
{
  Clear();
  theUnit = Tmsec;
  return( theStatus = tStatusSuccess );
}

#endif
