// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TTYPES_HH
#define __TTYPES_HH

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdio.h>
#include <string>
#include <list>


#define Tfalse 0
#define Ttrue 1
#define Tstd std
#define Tios Tstd::ios
#define Tin Tios::inin
#define Tout Tios::out
#define Tate Tios::ate
#define Tapp Tios::app
#define Ttrunc Tios::trunc
#define Tnocreate Tios::nocreate
#define Tnoreplace Tios::noreplace
#define Tbin Tios::bin
#define Tbinary Tios::binary
#define Tgoodbit Tios::goodbit
#define Teofbit Tios::eofbit
#define Tfailbit Tios::failbit
#define Tbadbit Tios::badbit
#define Tostream Tstd::ostream
#define Tlist Tstd::list
#define Tcout Tstd::cout
#define Tcin Tstd::cin
#define Tcerr Tstd::cerr
#define Tendl Tstd::endl
#define Tends Tstd::ends
#define Tdec Tstd::dec
#define Thex Tstd::hex
#define Toct Tstd::oct
#define Tflush Tstd::flush
#define Tsizeof(A) sizeof(A)


typedef double Tdouble;
typedef int Tint;
typedef float Tfloat;
typedef char Tchar;
typedef long Tlong;
typedef unsigned char TUchar;
typedef unsigned int TUint;
typedef unsigned long TUlong;
typedef short Tshort;
typedef unsigned short TUshort;
typedef bool Tbool;
typedef FILE TFileStream;
typedef size_t Tsize_t;
typedef time_t Ttime_t;
typedef void Tvoid;
typedef Tstd::string Tstring;
typedef ofstream Tofstream;
typedef ifstream Tifstream;


static const Tstring Tspace = " ";
static const Tstring Twspace = Tspace + Tspace;
static const Tstring Ttab = "\t";
static const Tstring Tbeep = "\b";
static const Tstring Tmsec = "ms";
static const Tstring Tsec = "s";
static const Tstring Tusec = "us";


enum Tobject_t { 
  tDataRecord, 
  tDataSection, 
  tDataSegment, 
  tDataElement, 
  tDataUnknown = -1
};

enum Telement_t {
  tTypeInt, 
  tTypeString, 
  tTypeDouble,
  tTypeObject,
  tTypeFloat,
  tTypeUnknown = -1
};

enum Tstream_t { 
  tFileStream, 
  tSocketStream,
  tSharedMemoryStream,
  tUnknownStream = -1
};

enum { 
  tIDunknown = -1
};

#endif
