// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectSocket.hh"
#include "TOutputObjectFile.hh"

int main( int argc, char** argv )
{
  enum { exCommand, exPort, exNumberOfArguments };

  if ( argc != exNumberOfArguments ) {
    Tcerr << "Usage: " << argv[ exCommand ];
    Tcerr << Tspace << "<port>";
    Tcerr << Tendl;
    return( -1 );
  }

  const Tint port = atoi( argv[ exPort ] );

  TInputObjectSocket* isocket = new TInputObjectSocket( port );
  TOutputObjectFile* ofile = new TOutputObjectFile( "test.obj" );

  Tint counter = 0;
  Tint datasize1 = 0;
  Tint datasize2 = 0;
  TDataRecord* record = 0;

  while ( ( record = (TDataRecord*)( isocket -> ReadData() ) ) ) {
    record -> Print();
    datasize1 += record -> GetDataSize();
    datasize2 += isocket -> GetDataSize();
    counter ++;

    delete record;
  }

  Tcout << Tendl;
  Tcout << Ttab << counter << " event, ";
  Tcout << datasize1 << "/" << datasize2 << " byte, read from ";
  Tcout << Tendl;
  Tcout << Tendl;

  delete ofile;
  delete isocket;

  return( 0 );
}
