// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TOutputObjectFile.hh"

int main( int argc, char** argv )
{
  const Tstring filename = "test.obj";
  TOutputObjectFile* ofile = new TOutputObjectFile( filename );
  Tint datasize = 0;

  Tstring s = "2002/04/21:09:50 -- STRING DATA STREAMABLE";
  Tint i = 0x1111;
  Tdouble d = 0.1234567;
  TDataElement* record = 0;
  
  record = new TDataElement( &s, tTypeString, 100 );
  ofile -> WriteData( record );
  record -> Print();
  datasize += record -> GetDataSize();
  delete record;

  record = new TDataElement( &i, tTypeInt, 200 );
  ofile -> WriteData( record );
  record -> Print();
  datasize += record -> GetDataSize();
  delete record;

  record = new TDataElement( &d, tTypeDouble, 300 );
  ofile -> WriteData( record );
  record -> Print();
  datasize += record -> GetDataSize();
  delete record;

  record = new TDataElement( &s, tTypeString, 400 );
  ofile -> WriteData( record );
  record -> Print();
  datasize += record -> GetDataSize();
  delete record;

  record = new TDataElement( &d, tTypeDouble, 500 );
  ofile -> WriteData( record );
  record -> Print();
  datasize += record -> GetDataSize();
  delete record;

  Tcout << Tendl;
  Tcout << Ttab << datasize << " byte data ---> " << filename << Tendl;
  Tcout << Tendl;

  delete ofile;

  return( 0 );
}
