// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TReadoutElement.hh"
#include "TSoftwareAdcModule.hh"

int main( int argc, char** argv )
{
  if ( argc != 2 ) {
    Tcerr << "Usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nev = atoi( argv[ 1 ] );
  const Tstring filename = "test.obj";
  Tint datasize = 0;

  TOutputObjectFile* ofile = new TOutputObjectFile( filename );

  TSoftwareAdcModule* adc1 = new TSoftwareAdcModule( 6, 4095, 0 );
  TSoftwareAdcModule* adc2 = new TSoftwareAdcModule( 8, 4095, 1 );

  TReadoutList* list = new TReadoutList( 0x1000 );
  TReadoutSection* sec = new TReadoutSection( 0x1100 );
  TReadoutSegment* seg1 = new TReadoutSegment( adc1, 0x1110 );
  TReadoutSegment* seg2 = new TReadoutSegment( 0x1120 );
  TReadoutElement* ele1 = new TReadoutElement( adc2, 0x0004 );
  TReadoutElement* ele2 = new TReadoutElement( adc2, 0x0005 );

  list -> Add( sec );
  sec -> Add( seg1 );
  sec -> Add( seg2 );
  seg2 -> Add( ele1 );
  seg2 -> Add( ele2 );

  TDataRecord* record = 0;
  for ( Tint i = 0; i < nev; i ++ ) {

    adc1 -> Update();
    adc2 -> Update();
    record = list -> ReadData();
    //record -> Print();
    ofile -> WriteData( record );
    datasize += record -> GetDataSize();

    delete record;
  }

  Tcout << Tendl;
  Tcout << Ttab << datasize << " byte data ---> " << filename << Tendl;
  Tcout << Tendl;


  delete list;
  delete adc1;
  delete adc2;
  delete ofile;

  return( 0 );
}
