// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TReadoutElement.hh"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareTdcModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TOutputObjectFile.hh"

int main( int argc, char** argv )
{
  if ( argc != 2 ) {
    Tcerr << "Usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nev = atoi( argv[ 1 ] );
  const Tstring filename = "test.obj";
  Tint datasize = 0;

  TOutputObjectFile* ofile = new TOutputObjectFile( filename );

  TSoftwareScalerModule* scaler = new TSoftwareScalerModule( 1 );
  TSoftwareClockModule* clock = new TSoftwareClockModule();
  TSoftwareTimerModule* timer = new TSoftwareTimerModule( Tusec );
  TSoftwareAdcModule* adc1 = new TSoftwareAdcModule( 6, 4095 );
  TSoftwareAdcModule* adc2 = new TSoftwareAdcModule( 8, 4095 );
  TSoftwareTdcModule* tdc1 = new TSoftwareTdcModule( 8, 8191 );
  TSoftwareTdcModule* tdc2 = new TSoftwareTdcModule( 8, 8191 );

  TReadoutList* list = new TReadoutList( 0x1000 );
  TReadoutSection* sec1 = new TReadoutSection( 0x1100 );
  TReadoutSegment* seg11 = new TReadoutSegment( scaler, 0x1110 );
  TReadoutSegment* seg12 = new TReadoutSegment( clock, 0x1120 );
  TReadoutSegment* seg13 = new TReadoutSegment( timer, 0x1110 );

  TReadoutSection* sec2 = new TReadoutSection( 0x1200 );
  TReadoutSegment* seg21 = new TReadoutSegment( adc1, 0x1210 );
  TReadoutSegment* seg22 = new TReadoutSegment( adc2, 0x1220 );

  TReadoutSection* sec3 = new TReadoutSection( 0x1300 );
  TReadoutSegment* seg31 = new TReadoutSegment( tdc1, 0x1310 );
  TReadoutSegment* seg32 = new TReadoutSegment( 0x1310 );
  TReadoutElement* ele324 = new TReadoutElement( tdc2, 0x004 );
  TReadoutElement* ele325 = new TReadoutElement( tdc2, 0x005 );
  TReadoutElement* ele326 = new TReadoutElement( tdc2, 0x006 );
  TReadoutElement* ele327 = new TReadoutElement( tdc2, 0x007 );

  list -> Add( sec1 );
  list -> Add( sec2 );
  list -> Add( sec3 );

  sec1 -> Add( seg11 );
  sec1 -> Add( seg12 );
  sec1 -> Add( seg13 );
  
  sec2 -> Add( seg21 );
  sec2 -> Add( seg22 );

  sec3 -> Add( seg31 );
  sec3 -> Add( seg32 );
  seg32 -> Add( ele324 );
  seg32 -> Add( ele325 );
  seg32 -> Add( ele326 );
  seg32 -> Add( ele327 );

  TDataRecord* record = 0;

  scaler -> Decrease();
  for ( Tint i = 0; i < nev; i ++ ) {

    // future .... crate -> Update()
    scaler -> Update();
    clock -> Update();
    timer -> Update();
    adc1 -> Update();
    adc2 -> Update();
    tdc1 -> Update();
    tdc2 -> Update();
    
    record = list -> ReadData();
    //record -> Print();
    ofile -> WriteData( record );
    datasize += record -> GetDataSize();


    delete record;
  }

  Tcout << Tendl;
  Tcout << Ttab << datasize << " byte data ---> " << filename << Tendl;
  Tcout << Tendl;


  delete list;

  // future .... delete crate
  delete timer;
  delete clock;
  delete scaler;
  delete adc1;
  delete adc2;
  delete tdc1;
  delete tdc2;

  delete ofile;

  return( 0 );
}
