// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "Tvector.hh"

typedef Tvector<Tdouble> dlist;

int main( int argc, char** argv )
{
  if ( argc != 2 ) {
    Tcerr << "Usage: " << argv[ 0 ] << Tspace << "<maxsize>" << Tendl;
    return( -1 );
  }

  static const Tint maxsize = atoi( argv[ 1 ] );

  dlist* l = new dlist();

  while(1){
  for ( Tdouble i = 0.0; i < maxsize; i ++ )
    l -> Add( new Tdouble( i ) );


  double* d = 0;
  l -> SetPosition( 0 );
  while ( ( d = l -> Next() ) ) {
    Tcout << *d << Ttab;
    Tcout << l -> GetCapacity() << Ttab;
    Tcout << l -> GetNumberOfEntries() << Ttab;
    Tcout << l -> GetPosition() << Ttab;
    Tcout << *(l -> Begin()) << Ttab;
    Tcout << *(l -> End()) << Ttab;
    Tcerr << l -> GetEndOfPosition() << Tendl;
  }

  Tcout << Tendl;

  l -> Remove( l -> GetEndOfPosition() );
  l -> Remove( l -> GetBeginOfPosition() );
  l -> Resize( ( l -> GetCapacity() ) * 100 );
  l -> Swap();

  l -> SetPosition( 0 );
  while ( ( d = l -> Next() ) ) {
    Tcout << *d << Ttab;
    Tcout << l -> GetCapacity() << Ttab;
    Tcout << l -> GetNumberOfEntries() << Ttab;
    Tcout << l -> GetPosition() << Ttab;
    Tcout << *(l -> Begin()) << Ttab;
    Tcout << *(l -> End()) << Ttab;
    Tcerr << l -> GetEndOfPosition() << Tendl;
  }

  l -> Clear();
  for ( Tdouble i = 0.0; i < maxsize; i ++ )
    l -> Add( new Tdouble( i ) );
  }

  delete l;


  return( 0 );
}
