// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "Tvector.hh"

typedef Tvector<Tdouble> TdoubleList;

int main( int argc, char** argv )
{
  if ( argc != 2 ) {
    Tcerr << "Usage: " << argv[ 0 ] << Tspace << "<maxsize>" << Tendl;
    return( -1 );
  }

  static const Tint maxsize = atoi( argv[ 1 ] );
  TdoubleList* l = new TdoubleList();

  while ( 1 ) {
    for ( Tdouble i = 0.0; i < maxsize; i ++ )
      l -> Add( new Tdouble( i * i * 3.14195 ) );

    Tdouble* d = 0;
    l -> SetPosition( 0 );
    while ( ( d = l -> Next() ) )
      Tcout << *d << Tendl;

    Tcout << Twspace << l -> GetCapacity() << Tendl;
    Tcout << l -> Remove( l -> GetEndOfPosition() ) << Tendl;
    l -> Clear();
  }

  delete l;


  return( 0 );
}
