// ============================================================
//  ExInputObjectFile.cc 
//  04-October-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#include "ExInputObjectFile.hh"
#include "ExStreamableObject.hh"
#include "ExVMEReadoutList.hh"
#include "ExVMEReadoutModule.hh"
#include "ExVMEReadoutChannel.hh"

ExInputObjectFile::ExInputObjectFile( char* path, char* mode )
  : ExObjectFile( path, mode )
{
  theObjectType = UNKNOWN;
  theLastEventSize = 0;
  theEventSize = 0;
}

ExInputObjectFile::ExInputObjectFile( char* path, int objecttype, char* mode )
  : ExObjectFile( path, mode )
{
  theObjectType = objecttype;
  theLastEventSize = 0;
  theEventSize = 0;
}

ExVMEReadoutList* ExInputObjectFile::create( ExVMEReadoutList* l )
{
  static const size_t lsize = sizeof( ExVMEReadoutList );
  l = (ExVMEReadoutList*)( malloc( lsize ) );
  if ( ( fread( l, lsize, 1, theFILE ) != 1 ) )
    return( 0 );
  theEventSize += lsize;
  int lentry = l -> getNumberOfEntries();
  int ltable = l -> getTableSize();
  int lid = l -> getID();
  free( l );
  ExVMEReadoutList* list = new ExVMEReadoutList( ltable, lid );
  ExVMEReadoutModule* m;
  for ( int i = 0; i < lentry; i ++ )
    list -> add( create( m ) );
  return( list );
}

ExVMEReadoutModule* ExInputObjectFile::create( ExVMEReadoutModule* m )
{
  static const size_t msize = sizeof( ExVMEReadoutModule );
  m = (ExVMEReadoutModule*)( malloc( msize ) );
  if ( ( fread( m, msize, 1, theFILE ) != 1 ) )
    return( 0 );
  theEventSize += msize;
  int mentry = m -> getNumberOfEntries();
  int mtable = m -> getTableSize();
  int mid = m -> getID();
  free( m );
  ExVMEReadoutModule* module = new ExVMEReadoutModule( mtable, mid );
  ExVMEReadoutChannel* c;
  for ( int i = 0; i < mentry; i ++ )
    module -> add( create( c ) );
  return( module );
}

ExVMEReadoutChannel* ExInputObjectFile::create( ExVMEReadoutChannel* c )
{
  static const size_t csize = sizeof( ExVMEReadoutChannel );
  c = (ExVMEReadoutChannel*)( malloc( csize ) );
  if ( ( fread( c, csize, 1, theFILE ) != 1 ) )
    return( 0 );
  theEventSize += csize;
  int cdata = c -> getData();
  int cid = c -> getID();
  free( c );
  ExVMEReadoutChannel* ch = new ExVMEReadoutChannel( cdata, cid );
  return( ch );
}

ExStreamableObject* ExInputObjectFile::get()
{ 
  theLastEventSize = theEventSize;
  theEventSize = 0;

  switch ( theObjectType ) {
    case EXVMEREADOUTLIST:
      ExVMEReadoutList* l;
      return( create( l ) );
      break;
    case EXVMEREADOUTMODULE:
      ExVMEReadoutModule* m;
      return( create( m ) );
      break;
    case EXVMEREADOUTCHANNEL:
      ExVMEReadoutChannel* c;
      return( create( c ) );
      break;
    case UNKNOWN:
    default:
      return( 0 );
  }
}
