// ============================================================
//  ExObjectArray.cc 
//  18-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================

#ifndef	__EXOBJECTARRAY_CC
#define	__EXOBJECTARRAY_CC

template <class T> ExObjectArray<T>::ExObjectArray( int tablesize )
{
  if ( tablesize )
    theObjects = new T* [ tablesize ];
  else
    theObjects = 0;

  theTableSize = tablesize;
  theNumberOfEntries = 0;
  theCounter = 0;
}

template <class T> ExObjectArray<T>::~ExObjectArray()
{
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    if ( theObjects[ i ] )
      delete theObjects[ i ];
  delete [] theObjects;
}

template <class T> void ExObjectArray<T>::allocate( int tablesize )
{
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    if ( theObjects[ i ] )
      delete theObjects[ i ];
  delete [] theObjects;

  theObjects = new T* [ tablesize ];

  theTableSize = tablesize;
  theNumberOfEntries = 0;
  theCounter = 0;

  return;
}

template <class T> int ExObjectArray<T>::add( T* object )
{
  if ( theNumberOfEntries >= theTableSize ) {
    theTableSize ++;
    T** newobjects = new T* [ theTableSize ];
    for ( int i = 0; i < theNumberOfEntries; i ++ )
      newobjects[ i ] = theObjects[ i ];
    delete [] theObjects;
    theObjects = newobjects;
  }
  theObjects[ theNumberOfEntries ] = object;
  theNumberOfEntries ++;
  return( theNumberOfEntries -1 );
}

template <class T> void ExObjectArray<T>::clear()
{
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    if ( theObjects[ i ] )
      delete theObjects[ i ];
  theNumberOfEntries = 0;
  theCounter = 0;
  return;
}

template <class T> void ExObjectArray<T>::reset()
{
  theCounter = 0;
  return;
}

template <class T> T* ExObjectArray<T>::next()
{
  if ( theCounter >= theNumberOfEntries )
    return( 0 );
  return( theObjects[ theCounter ++ ] );
}

template <class T> T* ExObjectArray<T>::get( int index ) const
{
  if ( index < 0 || index >= theNumberOfEntries )
    return( 0 );
  return( theObjects[ index ] );
}

#endif
