// ============================================================
//  ExObjectArray.hh
//  18-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#ifndef __EXOBJECTARRAY_HH
#define __EXOBJECTARRAY_HH

template <class T> class ExObjectArray {

protected:
  int theNumberOfEntries;
  int theTableSize;
  int theCounter;

  T** theObjects;

public:
  ExObjectArray( int tablesize );

  int add( T* object );
  void clear();
  void reset();
  void allocate( int tablesize = 0 );

  T* next();
  T* get( int index ) const;

public:
  inline int getCounter() const { return( theCounter ); }
  inline int getNumberOfEntries() const { return( theNumberOfEntries ); }
  inline int getTableSize() const { return( theTableSize ); }

  virtual ~ExObjectArray();

};

#include "ExObjectArray.cc"

#endif
