// ============================================================
//  ExVMEModule.cc 
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#include <errno.h>
#include <unistd.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "ExVMEModule.hh"
#include "ExVMEReadoutModule.hh"
#include "ExVMEReadoutChannel.hh"
#include "ExVMECrate.hh"

char* ExVMEModule::theDevices[ N_MODES ] = 
{
  "/dev/vmedrv16d16", "/dev/vmedrv16d32", "/dev/vmedrv24d16",
  "/dev/vmedrv24d32", "/dev/vmedrv32d16", "/dev/vmedrv32d32",
  "/dev/vmedrv24d16dma", "/dev/vmedrv32d16dma",
  "/dev/vmedrv24d32dma", "/dev/vmedrv32d32dma" 
};

int ExVMEModule::theTransferMode = UNKNOWN;

ExVMEModule::ExVMEModule( int offset, int mapsize, int mode )
{
  theTransferMode = mode;
  theOffset = (off_t) offset;
  theMapSize = (size_t) mapsize;
  theFileDescriptor = open( theDevices[ theTransferMode ], O_RDWR );
  theStatus = errno;
  theModuleBase
    = (caddr_t)mmap( 0, theMapSize, PROT_READ|PROT_WRITE, MAP_SHARED, theFileDescriptor, theOffset );
  theStatus = errno;
}

ExVMEModule::~ExVMEModule()
{
  munmap( theModuleBase, theMapSize );
  theStatus = errno;
  close( theFileDescriptor );
  theStatus = errno;
}

void ExVMEModule::setCrate( ExVMECrate* crate )
{
  //crate -> add( this );
  return;
}

void ExVMEModule::dump( ostream& os ) const
{
  return;
}
