// ============================================================
//  ExVMEReadoutChannel.cc 
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#include "ExVMEReadoutChannel.hh"
#include "ExObjectFile.hh"
#include "ExVMEModule.hh"

ExVMEReadoutChannel::ExVMEReadoutChannel( int data, int channelnumber )
  : ExStreamableObject( OBJECT_DATA, channelnumber )
{
  theModule = 0;
  theData = data;
}

ExVMEReadoutChannel::ExVMEReadoutChannel( ExVMEModule* module, int data, int channelnumber )
  : ExStreamableObject( OBJECT_DATA, channelnumber )
{
  theModule = module;
  theData = data;
}

void ExVMEReadoutChannel::dump( ostream& os )
{
  os << "          # Channel Number, ID: " << getID()
     << "  Data Value: " << getData() << endl;
  return;
}

size_t ExVMEReadoutChannel::getDataSize()
{
  size_t total = sizeof( ExVMEReadoutChannel );
  return( total );
}

size_t ExVMEReadoutChannel::put( ExObjectFile* objectfile )
{
  size_t size = fwrite( this, sizeof(*this), 1, objectfile -> getFILE() );
  return( size );
}

void ExVMEReadoutChannel::fillData( int data )
{
  if ( theModule == 0 )
    theData = data;  // fill dummy data
  else
    theModule -> fillData( this );
  return;
}
