// ============================================================
//  ExVMEReadoutModule.cc 
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#include "ExVMEReadoutModule.hh"
#include "ExObjectFile.hh"
#include "ExVMEModule.hh"

ExVMEReadoutModule::ExVMEReadoutModule( int tablesize, int listid )
  : ExVMEReadoutChannelArray( tablesize ), 
    ExStreamableObject( OBJECT_ARRAY, listid )
{
  theModule = 0;
}

ExVMEReadoutModule::ExVMEReadoutModule( ExVMEModule* module, int tablesize, int listid )
  : ExVMEReadoutChannelArray( tablesize ), 
    ExStreamableObject( OBJECT_ARRAY, listid )
{
  theModule = module;
}

void ExVMEReadoutModule::dump( ostream& os )
{
  os << "     % Readout VME Module, ID: " << getID() << endl
     << "     % Maximum Entry for Channel: " << getTableSize() << endl
     << "     % Current Counter: " << getCounter() << endl
     << "     % Filled Channel: " << getNumberOfEntries() << endl;

  for ( int i = 0; i < theNumberOfEntries; i ++ )
    theObjects[ i ] -> dump( os );

  return;
}

size_t ExVMEReadoutModule::getDataSize()
{
  size_t total;
  total = sizeof(*this);
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    total += theObjects[ i ] -> getDataSize();

  return( total );
}

size_t ExVMEReadoutModule::put( ExObjectFile* objectfile )
{
  size_t size = fwrite( this, sizeof(*this), 1, objectfile -> getFILE() );
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    size += theObjects[ i ] -> put( objectfile );
  return( size );
}

void ExVMEReadoutModule::fillData()
{
  if ( theModule == 0 )
    for ( int i = 0; i < theNumberOfEntries; i ++ )
      theObjects[ i ] -> fillData();
  else
    theModule -> fillData( this );
  return;
}
