// ============================================================
//  exOutputFile.cc
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#include "ExVMEReadoutList.hh"
#include "ExVMEReadoutModule.hh"
#include "ExVMEReadoutChannel.hh"
#include "ExOutputObjectFile.hh"

void create( ExVMEReadoutList* readoutlist, int v );

int main( int argc, char** argv )
{
  static const int nevent = 10;
  static int count = 0;
  static int nsize = 0;
  ExOutputObjectFile* ofile = new ExOutputObjectFile( "test.obj" );

  for ( int i = 0; i < nevent; i ++ ) {
    ExVMEReadoutList* list = new ExVMEReadoutList( 3, 0x1000 + i );
    
    create( list, i );
    ofile -> put( list );
    count ++;
    nsize += list -> getDataSize();
    list -> dump( cout);
    delete( list );
  }

  cout << "### number of events: " << count << endl;
  cout << "### total file size: " << nsize << endl;

  delete ofile;

  return( 0 );
}

void create( ExVMEReadoutList* readoutlist, int value )
{
  ExVMEReadoutModule* adc = new ExVMEReadoutModule( 4, 0 );
  ExVMEReadoutModule* tdc = new ExVMEReadoutModule( 8, 1 );
  ExVMEReadoutModule* scaler = new ExVMEReadoutModule( 6, 2 );

  adc -> add( new ExVMEReadoutChannel( value + 22, 0 ) );
  adc -> add( new ExVMEReadoutChannel( value + 44, 1 ) );
  adc -> add( new ExVMEReadoutChannel( value + 66, 2 ) );
  adc -> add( new ExVMEReadoutChannel( value + 88, 3 ) );

  tdc -> add( new ExVMEReadoutChannel( value * 10, 0 ) );
  tdc -> add( new ExVMEReadoutChannel( value * 20, 1 ) );
  tdc -> add( new ExVMEReadoutChannel( value * 30, 2 ) );
  tdc -> add( new ExVMEReadoutChannel( value * 40, 3 ) );
  tdc -> add( new ExVMEReadoutChannel( value * 50, 4 ) );
  tdc -> add( new ExVMEReadoutChannel( value * 60, 5 ) );
  tdc -> add( new ExVMEReadoutChannel( value * 70, 6 ) );
  tdc -> add( new ExVMEReadoutChannel( value * 80, 7 ) );

  scaler -> add( new ExVMEReadoutChannel( value + 99, 0 ) );
  scaler -> add( new ExVMEReadoutChannel( value + 77, 1 ) );
  scaler -> add( new ExVMEReadoutChannel( value + 66, 2 ) );
  scaler -> add( new ExVMEReadoutChannel( value + 55, 3 ) );
  scaler -> add( new ExVMEReadoutChannel( value + 33, 4 ) );
  scaler -> add( new ExVMEReadoutChannel( value + 11, 5 ) );

  readoutlist -> add( adc );
  readoutlist -> add( tdc );
  readoutlist -> add( scaler );

  return;
}
