// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TInputObjectFile.hh"
#include "TStreamableObject.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TDataFilter.hh"

TInputObjectFile::TInputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TInputObjectStream( tFileStream )
{;}

TInputObjectFile::TInputObjectFile( TDataFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TInputObjectStream( filter, tFileStream )
{;}

TInputObjectFile::~TInputObjectFile()
{;}

Tint TInputObjectFile::ReadData( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;

  if ( HasFilter() )
    return( theDataFilter -> Analyze( object, this ) );
  

  static Tobject_t objecttype = object.GetObjectType();

  switch ( objecttype ) {
    case tDataRecord:
      *( (TDataRecord*)(&object) ) = getDataRecord();
      break;
    case tDataSection:
      *( (TDataSection*)(&object) ) = getDataSection();
      break;
    case tDataSegment:
      *( (TDataSegment*)(&object) ) = getDataSegment();
      break;
    case tDataElement:
      *( (TDataElement*)(&object) ) = getDataElement();
      break;
    case tDataUnknown:
    default:
      break;
  }

  return( theDataSize );
}

TDataRecord TInputObjectFile::getDataRecord()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataRecord record( id );
  if ( theDataSize == 0 )
    return( record );

  for ( Tint i = 0; i < entries; i ++ )
    record.push_back( getDataSection() );

  return( record );
}

TDataSection TInputObjectFile::getDataSection()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataSection section( id );
  if ( theDataSize == 0 )
    return( section );

  for ( Tint i = 0; i < entries; i ++ )
    section.push_back( getDataSegment() );

  return( section );
}

TDataSegment TInputObjectFile::getDataSegment()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataSegment segment( id );
  if ( theDataSize == 0 )
    return( segment );

  for ( Tint i = 0; i < entries; i ++ )
    segment.push_back( getDataElement() );

  return( segment );
}

TDataElement TInputObjectFile::getDataElement()
{
  static const Tsize_t nmemb = 1;
  Tint id;
  Telement_t type;
  Tint nprvs;
  TDataElement element;

  // read id
  if ( ( fread( &id, Tsizeof( id ), nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::getDataElement" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return( element );
  } else {
    theDataSize += Tsizeof( id );
    element.SetID( id );
  }

  // read element type
  if ( ( fread( &type, Tsizeof( type ), nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::getDataElement" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return( element );
  } else {
    theDataSize += Tsizeof( type );
    element.SetElementType( type );
  }

  // read number of primitives
  if ( ( fread( &nprvs, Tsizeof( nprvs ), nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::getDataElement" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return( element );
  } else {
    theDataSize += Tsizeof( nprvs );
    element.SetNumberOfPrimitives( nprvs );
  }

  Tstring* strbuf = 0;
  Tchar* cc = 0;
  Tint* ii = 0;
  Tdouble* dd = 0;
  TUshort* ww = 0;

  switch ( type ) {

    case tTypeInt:
      ii = new Tint[ nprvs ];
      if ( fread( ii, Tsizeof( Tint ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ii, nprvs );
	theDataSize += (Tint)( Tsizeof( Tint ) * nprvs );
      }
      delete [] ii;
      break;

    case tTypeString:
      strbuf = new Tstring[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	Tint nchar;
	if ( fread( &nchar, Tsizeof( Tint ), nmemb, theFileStream ) != (Tsize_t)nmemb ) {
	  SetOffset( 0, SEEK_END );
	  theDataSize = 0;
	  return( element );
	} else {
	  theDataSize += (Tint)( Tsizeof( Tint ) * nmemb );
	  cc = new Tchar[ nchar ];
	}
	if ( fread( cc, Tsizeof( Tchar ) * nchar, nmemb, theFileStream ) != (Tsize_t)nmemb ) {
	  //perror( "TInputObjectFile::getDataElement" );
	  SetOffset( 0, SEEK_END );
	  theDataSize = 0;
	  return( element );
	} else {
	  theDataSize += (Tint)( Tsizeof( Tchar ) * nchar );
	}
	strbuf[ i ] = cc;
	delete [] cc;
      }
      element.FillData( strbuf, nprvs );
      delete [] strbuf;
      break;

    case tTypeDouble:
      dd = new Tdouble[ nprvs ];

      if ( fread( dd, Tsizeof( Tdouble ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( dd, nprvs );
	theDataSize += (Tint)( Tsizeof( Tdouble ) * nprvs );
      }
      delete [] dd;
      break;

    case tTypeWord:
    case tTypeUnsignedShort:
    case tTypeShort:
      ww = new TUshort[ nprvs ];

      if ( fread( ww, Tsizeof( TUshort ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ww, nprvs );
	theDataSize += (Tint)( Tsizeof( TUshort ) * nprvs );
      }
      delete [] ww;
      break;


    case tTypeUnknown:
    case tTypeObject:
    case tTypeFloat:
    default:
      break;
  }

  return( element );
}

Tvoid TInputObjectFile::readProperties( Tint& id, Tint& entries )
{
  static const Tsize_t nmemb = 1;
  static const Tint datasize = Tsizeof( Tint );

  // ɤߤ˼ԤȤν⤦礤ޤ˹ͤʤ
  // SEEK ƸˤɤäꡢΥ쥳ɤФƤߤȤ
  // ȡꥪץȤεǽɬ

  if ( ( fread( &id, datasize, nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::readProperties" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return;
  } else {
    theDataSize += datasize;
  }

  if ( ( fread( &entries, datasize, nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::readProperties" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return;
  } else {
    theDataSize += datasize;
  }

  return;
}
