// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TINPUTOBJECTSOCKET_HH
#define __TINPUTOBJECTSOCKET_HH

#include "TGlobals.hh"
#include "TObjectSocket.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TDataFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TInputObjectSocket
  : public TObjectSocket, public TInputObjectStream
{

  private:
    enum { tDefaultBackLog = 5 };

  private:
    Tint theClientDescriptor;

  public:
    TInputObjectSocket( Tint port = tDefaultPortNumber );
    TInputObjectSocket( TDataFilter* filter, Tint port = tDefaultPortNumber );
    ~TInputObjectSocket();

  public:
    Tint ReadData( TStreamableObject& object );

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& id, Tint& entries );
    Tvoid initialize();

  public:
    Tint GetClientDescriptor() const;
    // GetClientHostName()
    // GetClientPort()
    Tint OpenClient();
    Tint CloseClient();

};


inline Tint TInputObjectSocket::GetClientDescriptor() const
{
  return( theClientDescriptor );
}

#endif
