// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOBJECTSOCKET_HH
#define __TOBJECTSOCKET_HH

#include "TGlobals.hh"

class TObjectSocket
{

  protected:
    enum { tDefaultPortNumber = 18150 };

  protected:
    Tint theServerDescriptor;
    Tint thePortNumber;
    struct sockaddr_in theAddress;

  public:
    TObjectSocket( Tint portnumber );

  protected:
    virtual ~TObjectSocket();

  public:
    Tint GetServerDescriptor() const;
    Tint GetPortNumber() const;

  public:
    Tint OpenServer();
    Tint CloseServer();

};

inline Tint TObjectSocket::GetServerDescriptor() const
{
  return( theServerDescriptor );
}

inline Tint TObjectSocket::GetPortNumber() const
{
  return( thePortNumber );
}

#endif
