// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TOutputObjectFile.hh"

TOutputObjectFile::TOutputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( tFileStream )
{;}

TOutputObjectFile::TOutputObjectFile( TDataFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( filter, tFileStream )
{;}

TOutputObjectFile::~TOutputObjectFile()
{;}

Tint TOutputObjectFile::WriteData( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;
  if ( HasFilter() )
    theDataSize = theDataFilter -> Filter( object, this );
  else
    theDataSize = object.WriteData( this );
  return( theDataSize );
}
