// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TOutputObjectSocket.hh"
#include "TStreamableObject.hh"
#include "TDataFilter.hh"

TOutputObjectSocket::TOutputObjectSocket( const Tstring& hostname, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( tSocketStream ), 
    theServerName( hostname ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( Tint port )
  : TObjectSocket( port ), TOutputObjectStream( tSocketStream ), 
    theServerName( "localhost" ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( TDataFilter* filter, const Tstring& hostname, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( filter, tSocketStream ), 
    theServerName( hostname ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( TDataFilter* filter, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( filter, tSocketStream ), 
    theServerName( "localhost" ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::~TOutputObjectSocket()
{
  CloseServer();
}

Tvoid TOutputObjectSocket::initialize()
{
  theHostInformation = gethostbyname( theServerName.c_str() );
  if ( theHostInformation == 0 ) {
    perror( "TOutputObjectSocket::initialize" );
    exit( -errno );
  }
  theAddress.sin_family = PF_INET;
  theAddress.sin_port = htons( (TUshort)thePortNumber );
  theAddress.sin_addr.s_addr =
    *( (unsigned long *)( *( theHostInformation -> h_addr_list ) ) );

  OpenServer();
  socklen_t len = (socklen_t)( Tsizeof( theAddress ) );

  if ( connect( theServerDescriptor, (struct sockaddr *)&theAddress, len ) == -1 )
    perror( "TOutputObjectSocket::initialize" );


  return;
}

Tint TOutputObjectSocket::WriteData( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;

  if ( HasFilter() )
    theDataSize = theDataFilter -> Filter( object, this );
  else
    theDataSize = object.WriteData( this );

  return( theDataSize );
}
