// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TUSERINTERFACE_HH
#define __TUSERINTERFACE_HH

#include "TGlobals.hh"

class TCommand;

// ҥȥ꡼ե
// Хå⡼
class TUserInterface
{

  protected:
    TCommand** theCommandList;
    Tint theCommandListCapacity;
    Tint theNumberOfCommands;
    Tint theCommandIndex;

  public:
    Tint AddCommand( TCommand* command );
    Tint RemoveCommand( Tint index );
    Tvoid ClearCommandList();
    Tbool ResizeCommandList( Tint capacity );
    TCommand* NextCommand();
    TCommand* FindCommand( const Tstring& command );
    TCommand* GetCommand( Tint index );
    TCommand* GetCommand();
    Tvoid ExecuteCommand( const Tstring& command );

  public:
    Tint GetCommandListCapacity() const;
    Tint GetNumberOfCommands() const;
    Tint GetCommandIndex() const;
    Tvoid SetCommandIndex( Tint index );

  protected:
    Tvoid free();
    Tvoid allocate( Tint capacity );

  public:
    TUserInterface();
    virtual ~TUserInterface();

  public:
    virtual Tvoid SessionStart() = 0;

};

inline Tint TUserInterface::GetCommandListCapacity() const
{
  return( theCommandListCapacity );
}

inline Tint TUserInterface::GetNumberOfCommands() const
{
  return( theNumberOfCommands );
}

inline Tint TUserInterface::GetCommandIndex() const
{
  return( theCommandIndex );
}

inline Tvoid TUserInterface::SetCommandIndex( Tint index )
{
  theCommandIndex = index;
  return;
}

#endif
