#include "TString.h"
#include "TCanvas.h"
#include "TNtuple.h"

void test()
{
  gROOT -> Reset();
  gStyle -> SetOptStat( 1111111 );
  gStyle -> SetOptFit( 1111 );

  TCanvas* canvas = new TCanvas( "canvas", "Software ADC DATA", 20, 20, 640, 640 );
  const int nch = 8;
  int ich[ nch ];
  TString sch[ 8 ] = { "ch0","ch1","ch2","ch3","ch4","ch5","ch6","ch7" };

  TString varlist;
  for ( int i = 0; i < nch; i ++ ) {
    varlist += sch[ i ];
    if ( i != nch - 1 )
      varlist += ":";
  }


  TNtuple* adc = new TNtuple( "ADC", "Software ADC DATA", varlist.Data() );
  ifstream ifs;
  ifs.open( "test.dat" );
  while ( !( ifs.eof() ) ) {
    for ( int i = 0; i < nch; i ++ )
      ifs >> ich[ i ];
    adc->Fill(ich[0],ich[1],ich[2],ich[3],ich[4],ich[5],ich[6],ich[7]);
  }
  ifs.close();
  canvas -> Divide( 2, 4 );

  for ( int i = 0; i < nch; i ++ ) {
    canvas -> cd( i + 1 );
    TString opt = sch[ i ];
    opt += ">0.0";
    adc -> Draw( sch[ i ].Data(), opt.Data() );
    htemp -> GetXaxis() -> 
      SetRange(htemp->GetXaxis()->FindBin(0.0),htemp->GetXaxis()->FindBin(4095.0));
    htemp -> Fit( "gaus" );
  }


  canvas -> cd ( 0 );
  canvas -> Print( "test_root.ps" );
  delete adc;
  //delete canvas;
}
