// ============================================================
//  ExVMEModule.hh
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#ifndef __EXVMEMODULE_HH
#define __EXVMEMODULE_HH

#include <sys/types.h>
#include <stdio.h>
#include <iostream.h>

#ifndef __USE_BSD
typedef __caddr_t caddr_t;
#endif
class ExVMEReadoutModule;
class ExVMEReadoutChannel;
class ExVMECrate;
class ostream;

class ExVMEModule {

public:
  enum {
    A16D16, A16D32, A24D16, A24D32, A32D16, A32D32, 
    A24D16DMA, A32D16DMA, A24D32DMA, A32D32DMA, 
    N_MODES, UNKNOWN = -1
  };

protected:
  int theStatus;
  int theFileDescriptor;
  off_t theOffset;
  size_t theMapSize;
  caddr_t theModuleBase;

public:
  ExVMEModule( int offset, int mapsize = 0x1000, int mode = UNKNOWN );
  virtual ~ExVMEModule();

public:
  virtual void clear() = 0;
  virtual void update() = 0;
  virtual void initialize() = 0;
  virtual void fillData( ExVMEReadoutModule* module ) = 0;
  virtual void fillData( ExVMEReadoutChannel* channel ) = 0;

public:
  inline virtual off_t getHardwareAddress() const { return( theOffset ); }
  inline virtual size_t getMapSize() const { return( theMapSize ); }
  inline virtual int getFileDescriptor() const { return( theFileDescriptor ); }
  inline virtual int getStatus() const { return( theStatus ); }
  inline virtual caddr_t getModuleBase() const { return( theModuleBase ); }
  inline virtual void showStatus( char* str = "ExVMEModule" ) const { perror( str ); }

public:
  virtual void dump( ostream& os = cout ) const;
  virtual void setCrate( ExVMECrate* crate );

protected:
  static char* theDevices[ N_MODES ];
  static int theTransferMode;

public:
  inline static char* getDevice() { return( theDevices[ theTransferMode ] ); }
  inline static int getTransferMode() { return( theTransferMode ); }

};

#endif
