// ============================================================
//  ExVMERPV130Module.cc 
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#include "ExVMERPV130Module.hh"
#include "ExVMEReadoutModule.hh"
#include "ExVMEReadoutChannel.hh"

ExVMERPV130Module::ExVMERPV130Module( int offset, int mapsize, int mode )
  : ExVMEModule( offset, mapsize, mode )
{;}

ExVMERPV130Module::~ExVMERPV130Module()
{;}

void ExVMERPV130Module::clear()
{
  *( ( unsigned short* )( theModuleBase + CSR1 ) ) |= 0x03;
  *( ( unsigned short* )( theModuleBase + CSR2 ) ) |= 0x03;
  return;
}

void ExVMERPV130Module::update()
{
  clear();
  return;
}

void ExVMERPV130Module::initialize()
{
  clear();
  disable();
  return;
}

void ExVMERPV130Module::fillData( ExVMEReadoutModule* module )
{
  ExVMEReadoutChannel* channel;
  module -> reset();
  while ( ( channel = module -> next() ) )
    fillData( channel );
  return;
}

void ExVMERPV130Module::fillData( ExVMEReadoutChannel* channel )
{
  channel -> setData( read( channel -> getID(), THROUGH_MODE ) );
  return;
}

void ExVMERPV130Module::pulse()
{
  *( ( unsigned short* )( theModuleBase + PULSE ) ) |= 0xff;
  return;
}

void ExVMERPV130Module::pulse( int channel )
{
  int out = 1;
  out = out << ( channel - 1 );
  *( ( unsigned short* )( theModuleBase + PULSE ) ) = (unsigned short)out;
  return;
}

void ExVMERPV130Module::level()
{
  *( ( unsigned short* )( theModuleBase + LEVEL ) ) |= 0xff;
  return;
}

void ExVMERPV130Module::level( int channel )
{
  int out = 1;
  out = out << ( channel - 1 );
  *( ( unsigned short* )( theModuleBase + LEVEL ) ) = (unsigned short)out;
  return;
}

void ExVMERPV130Module::enable()
{
  *( ( unsigned short* )( theModuleBase + CSR1 ) ) |= 0x50;
  *( ( unsigned short* )( theModuleBase + CSR2 ) ) |= 0x50;
  return;
}

void ExVMERPV130Module::disable()
{
  // incomplete
  //*( ( unsigned short* )( theModuleBase + CSR1 ) ) |= 0x03;
  //*( ( unsigned short* )( theModuleBase + CSR2 ) ) |= 0x03;
  return;
}

int ExVMERPV130Module::read( read_t mode )
{
  unsigned short data;
  switch ( mode ) {
  case LATCH1_MODE:
    data = *( ( unsigned short* )( theModuleBase + LATCH1 ) );
  case LATCH2_MODE:
    data = *( ( unsigned short* )( theModuleBase + LATCH2 ) );
  case RSFF_MODE:
    data = *( ( unsigned short* )( theModuleBase + RSFF ) );
  case THROUGH_MODE:
    data = *( ( unsigned short* )( theModuleBase + THROUGH ) );
  default:
    data = *( ( unsigned short* )( theModuleBase + RSFF ) );
  }
  data = data & 0xff;
  return( (int)data );
}

int ExVMERPV130Module::read( int channel, read_t mode )
{
  int data = read( mode );
  data = data >> ( channel - 1 );
  data = data & 1;
  return( data );
}
