// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TCRATE_HH
#define __TCRATE_HH

#include "TGlobals.hh"

class TModuleList;

class TCrate
{
  protected:
    enum { tStatusSuccess = 0 };

  public:
    enum { tOffline, tOnline };

  protected:
    Tint theStatus;
    Tint thePower;
    TModuleList* theModuleList;

  public:
    virtual Tint Clear() = 0;
    virtual Tint Update() = 0;
    virtual Tint Initialize() = 0;

    virtual Tint Install( TModule* module );

  public:
    inline virtual Tvoid Print( Tostream& tos = Tstd::Tcout ) const;

  public:
    TCrate( Tint status = 0 );

  protected:
    virtual ~TCrate();

  public:
    Tint GetStatus() const;
    Tvoid SetStatus( Tint status );

    Tbool IsSuccess() const;
};

inline Tint TCrate::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TCrate::SetStatus( Tint status )
{
  theStatus = status;
  return;
}

inline Tbool TCrate::IsSuccess() const
{
  return( ( theStatus >= 0 ) ? Ttrue : Tfalse );
}

inline Tvoid TCrate::Print( Tostream& tos ) const
{
  Tstring head = "* Crate, ";
  tos << head << "Status: " << theStatus << Tendl;
  return;
}

#endif
