// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TRun.hh"

TRun::TRun( Tint stackSize )
  : theRunNumber( 0 ), theNumberOfEvents( 0 ), theStackSize( stackSize )
{
  theEventList.clear();
}

TRun::TRun( const TRun& right )
  : theRunNumber( right.theRunNumber ), 
    theNumberOfEvents( right.theNumberOfEvents ), 
    theStackSize( right.theStackSize ), 
    theEventList( right.theEventList )
{;}

TRun::~TRun()
{;}

const TRun& TRun::operator=( const TRun& right )
{
  theRunNumber = right.theRunNumber;
  theNumberOfEvents = right.theNumberOfEvents;
  theStackSize = right.theStackSize;
  theEventList = right.theEventList;
  return( *this );
}

Tvoid TRun::RecordEvent( const TEvent& event )
{
  if ( theNumberOfEvents < theStackSize )
    theEventList.push_back( event );
  else
    theEventList[ theNumberOfEvents % theStackSize ] = event;

  theNumberOfEvents ++;
  return;
}
