// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TRUN_HH
#define __TRUN_HH

#include "TGlobals.hh"
#include "TEventList.hh"

class TRun
{

  private:
    enum { tDefaultStackSize = 100 };

  private:
    Tint theRunNumber;
    Tint theNumberOfEvents;
    Tint theStackSize;
    TEventList theEventList;

  public:
    TRun( Tint stackSize = tDefaultStackSize );
    TRun( const TRun& right );
    virtual ~TRun();

  public:
    const TRun& operator=( const TRun& right );
    virtual Tvoid RecordEvent( const TEvent& event );

  public:
    Tint GetRunNumber() const;
    Tint GetNumberOfEvents() const;
    Tint GetStackSize() const;
    const TEventList& GetEventList() const;

    Tvoid SetRunNumber( Tint runNumber );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetStackSize( Tint stacksize );
    Tvoid SetEventList( const TEventList& evtlist );

};

inline Tint TRun::GetRunNumber() const
{
  return( theRunNumber );
}

inline Tint TRun::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline Tint TRun::GetStackSize() const
{
  return( theStackSize );
}

inline const TEventList& TRun::GetEventList() const
{
  return( theEventList );
}

inline Tvoid TRun::SetRunNumber( Tint runNumber )
{
  theRunNumber = runNumber;
  return;
}

inline Tvoid TRun::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid TRun::SetStackSize( Tint stacksize )
{
  theStackSize = stacksize;
  return;
}

inline Tvoid TRun::SetEventList( const TEventList& evtlist )
{
  theEventList = evtlist;
  return;
}

#endif
