// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TRUNMANAGER_HH
#define __TRUNMANAGER_HH

#include "TGlobals.hh"
#include "TUserInterface.hh"

class TUserInterface;
class TCommand;

class TRunManager {

  private:
    Tstatus_t theStatus;
    TstringList theWaitingCommands;

  private:
    static TRunManager* theRunManager;

  protected:
    TUserInterface* theUserInterface;

  public:
    TRunManager( TUserInterface* ui = 0 );
    virtual ~TRunManager();

  public:
    virtual TUserInterface* GetUserInterface() const;
    virtual Tstatus_t GetStatus() const;
    virtual const TstringList& GetWaitingCommands() const;
    virtual Tvoid SetUserInterface( TUserInterface* ui );
    virtual Tint SetUserCommand( TCommand* command ) const;
    virtual Tvoid SetStatus( Tstatus_t status );
    virtual Tvoid SetWaitingCommands( const TstringList& coms );

  public:
    virtual Tvoid SessionStart() const;
    virtual Tvoid ShowStatus() const;
    virtual Tvoid AddWaitingCommand( const Tstring& com );
    virtual Tstring GetWaitingCommand() const;
    virtual Tstring GetWaitingCommand( Tint index ) const;
    virtual Tvoid ClearWaitingCommand();
    virtual Tvoid RemoveWaitingCommand( Tint index );
    virtual Tvoid RemoveWaitingCommand();
    virtual Tbool HasWaitingCommand() const;
    virtual Tvoid ExecuteWaitingCommand();
    virtual Tvoid ExecuteWaitingCommand( Tint index );
    virtual Tvoid ShowWaitingCommands() const;

  public:
    static const TRunManager* GetRunManager();

};

inline TUserInterface* TRunManager::GetUserInterface() const
{
  return( theUserInterface );
}

inline Tstatus_t TRunManager::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TRunManager::SetUserInterface( TUserInterface* ui )
{
  theUserInterface = ui;
  return;
}

inline Tvoid TRunManager::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

inline const TstringList& TRunManager::GetWaitingCommands() const
{
  return( theWaitingCommands );
}

inline Tvoid TRunManager::SetWaitingCommands( const TstringList& coms )
{
  theWaitingCommands = coms;
  return;
}

inline const TRunManager* TRunManager::GetRunManager()
{
  if ( theRunManager == 0 )
    theRunManager = new TRunManager();
  return( theRunManager );
}


inline Tvoid TRunManager::AddWaitingCommand( const Tstring& com )
{
  theWaitingCommands.push_back( com );
  return;
}

inline Tstring TRunManager::GetWaitingCommand() const
{
  return( GetWaitingCommand( 0 ) );
}

inline Tstring TRunManager::GetWaitingCommand( Tint index ) const
{
  Tstring nullstr;
  if ( !( HasWaitingCommand() ) || (Tint)theWaitingCommands.size() <= index )
    return( nullstr );
  else
    return( theWaitingCommands[ index ] );
}

inline Tvoid TRunManager::ClearWaitingCommand()
{
  theWaitingCommands.clear();
  return;
}

inline Tvoid TRunManager::RemoveWaitingCommand()
{
  return( RemoveWaitingCommand( 0 ) );
}

inline Tvoid TRunManager::RemoveWaitingCommand( Tint index )
{
  if ( HasWaitingCommand() && (Tint)theWaitingCommands.size() > index )
    theWaitingCommands.erase( theWaitingCommands.begin() + index );
  return;
}

inline Tbool TRunManager::HasWaitingCommand() const
{
  return( !( theWaitingCommands.empty() ) );
}

inline Tvoid TRunManager::ExecuteWaitingCommand()
{
  return( ExecuteWaitingCommand( 0 ) );
}

inline Tvoid TRunManager::ExecuteWaitingCommand( Tint index )
{
  if ( HasWaitingCommand() && (Tint)theWaitingCommands.size() > index ) {
    theUserInterface -> ExecuteCommand( theWaitingCommands[ index ] );
    RemoveWaitingCommand( index );
  }
  return;
}

inline Tvoid TRunManager::ShowWaitingCommands() const
{
  if ( HasWaitingCommand() ) {
    for ( Tint i = 0; i < (Tint)theWaitingCommands.size(); i ++ ) {
      Tcout << theWaitingCommands[ i ];
      if ( i != (Tint)( theWaitingCommands.size() - 1 ) )
	Tcout << Twspace;
    }
    Tcout << Tendl;
  }
  return;
}

#endif
