// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSoftwareScalerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareScalerModule::TSoftwareScalerModule( Tint nchannel, Tint id )
  : TSoftwareModule( nchannel, id ), theChannel( nchannel, 0 )
{;}

TSoftwareScalerModule::TSoftwareScalerModule( const TSoftwareScalerModule& right )
  : TSoftwareModule( right ), theChannel( right.theChannel )
{;}

TSoftwareScalerModule::~TSoftwareScalerModule()
{;}

Tvoid TSoftwareScalerModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    Tint data = theChannel[ i ];
    TDataElement element( &data, tTypeInt, i );
    ((TDataElementList*)(&segment)) -> push_back( element );
  }
  return;
}

Tvoid TSoftwareScalerModule::FillData( const TDataElement& element )
{
  Tint ch = element.GetID();
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TSoftwareScalerModule::FillData: invalid ID" << Tendl;
    Tint tmp = -EFAULT;
    theStatus = -EFAULT;
    ((TDataElement*)(&element)) -> FillData( &tmp, tTypeInt );
  } else {
    Tint data = theChannel[ ch ];
    ((TDataElement*)(&element)) -> FillData( &data, tTypeInt );
  }
  return;
}

const TSoftwareScalerModule& TSoftwareScalerModule::operator=( const TSoftwareScalerModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theChannel = right.theChannel;
  return( *this );
}

Tbool TSoftwareScalerModule::operator==( const TSoftwareScalerModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( theChannel == right.theChannel );
  return( ret );
}

Tbool TSoftwareScalerModule::operator!=( const TSoftwareScalerModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret &= ( theChannel != right.theChannel );
  return( ret );
}
